<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no,  maximum-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="icon" href="<?php echo e(asset(get_option('primary_data',true)['favicon'] ?? '')); ?>" type="image/png">

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">

    <meta name="app-name" content="<?php echo e(config('app.name')); ?>" />
    <meta name="app-translations" content="<?php echo e(getTranslationFile()); ?>" />
    <title inertia><?php echo e(config('app.name', 'Laravel')); ?></title>
    <script>
        "use strict"
        if (
            localStorage.getItem('theme') === 'dark' ||
            (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    </script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom.css')); ?>" media="all">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom-toastr.css')); ?>" media="all">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/payment.css')); ?>">

    <script src="<?php echo e(asset('assets/js/initialLoader.js')); ?>" async></script>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/custom-tiptap.css')); ?>" media="all">
    
    <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
    <?php
    $activeModule = isset($page['props']['activeModule']) ? $page['props']['activeModule'] : null;
    $capitalizeModule = ucfirst($activeModule);
    ?>
    <?php if($activeModule && $activeModule != 'user'): ?>
    <?php if(Vite::isRunningHot()): ?>
    <?php echo app('Illuminate\Foundation\Vite')(["modules/{$capitalizeModule}/resources/js/app.js",
    "modules/{$capitalizeModule}/resources/js/Pages/{$page['component']}.vue"]); ?>
    <?php endif; ?>

    <?php if(Vite::isRunningHot() == false): ?>
    <?php echo e(module_vite('build-' . $activeModule, 'resources/js/app.js')); ?>

    <?php endif; ?>
    <?php else: ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
    <?php endif; ?>
    <?php if(Vite::isRunningHot()): ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/admin/main.scss']); ?>
    <?php else: ?>
    <?php echo e(module_vite('build', 'resources/scss/admin/main.scss')); ?>

    <?php endif; ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>
</head>

<body>
    <?php echo $__env->make('layouts.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
</body>

</html><?php /**PATH /Volumes/my-works/laravel/socialai/resources/views/layouts/admin.blade.php ENDPATH**/ ?>