<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Plan;

class PlansTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $plans = array(
            array('id' => '1','title' => 'Enterprise','description' => 'Suitable for Enterprise Level Business','price' => '20','is_featured' => '1','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '30','trial_days' => '7','data' => '{"credits":{"value":8000,"overview":"Credit: 8000"},"brands":{"value":20,"overview":"Max 20 Brands"},"social_accounts":{"value":20,"overview":"Max 20 Social Account"},"posts":{"value":100,"overview":"Max 100 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:59:01'),
            array('id' => '4','title' => 'Starter','description' => 'Suitable for Startup Level Business','price' => '10','is_featured' => '1','is_recommended' => '1','is_default' => '0','is_trial' => '1','status' => '1','days' => '30','trial_days' => '7','data' => '{"credits":{"value":5000,"overview":"Credit: 5000"},"brands":{"value":11,"overview":"Max 10 Brands"},"social_accounts":{"value":10,"overview":"Max 10 Social Account"},"posts":{"value":25,"overview":"Max 25 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '5','title' => 'Advance','description' => 'Suitable for Stable Level Business','price' => '30','is_featured' => '1','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '30','trial_days' => '7','data' => '{"credits":{"value":20000,"overview":"Credit: 20000"},"brands":{"value":-1,"overview":"Unlimited Brands"},"social_accounts":{"value":-1,"overview":"Unlimited Social Account"},"posts":{"value":-1,"overview":"Unlimited Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 18:03:01'),
            array('id' => '6','title' => 'Enterprise','description' => 'Suitable for Enterprise Level Business','price' => '230','is_featured' => '1','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => '0','data' => '{"credits":{"value":5000,"overview":"Credit: 5000"},"brands":{"value":11,"overview":"Max 10 Brands"},"social_accounts":{"value":10,"overview":"Max 10 Social Account"},"posts":{"value":25,"overview":"Max 25 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '7','title' => 'Starter','description' => 'Suitable for Startup Level Business','price' => '110','is_featured' => '1','is_recommended' => '1','is_default' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => '0','data' => '{"credits":{"value":5000,"overview":"Credit: 5000"},"brands":{"value":11,"overview":"Max 10 Brands"},"social_accounts":{"value":10,"overview":"Max 10 Social Account"},"posts":{"value":25,"overview":"Max 25 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '8','title' => 'Advance','description' => 'Suitable for Stable Level Business','price' => '350','is_featured' => '0','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '365','trial_days' => '0','data' => '{"credits":{"value":20000,"overview":"Credit: 20000"},"brands":{"value":-1,"overview":"Unlimited Brands"},"social_accounts":{"value":-1,"overview":"Unlimited Social Account"},"posts":{"value":-1,"overview":"Unlimited Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '9','title' => 'Enterprise','description' => 'Suitable for Enterprise Level Business','price' => '500','is_featured' => '1','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '9999','trial_days' => '0','data' => '{"credits":{"value":5000,"overview":"Credit: 5000"},"brands":{"value":11,"overview":"Max 10 Brands"},"social_accounts":{"value":10,"overview":"Max 10 Social Account"},"posts":{"value":25,"overview":"Max 25 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '10','title' => 'Starter','description' => 'Suitable for Startup Level Business','price' => '400','is_featured' => '1','is_recommended' => '1','is_default' => '0','is_trial' => '0','status' => '1','days' => '9999','trial_days' => '0','data' => '{"credits":{"value":5000,"overview":"Credit: 5000"},"brands":{"value":11,"overview":"Max 10 Brands"},"social_accounts":{"value":10,"overview":"Max 10 Social Account"},"posts":{"value":25,"overview":"Max 25 Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26'),
            array('id' => '11','title' => 'Advance','description' => 'Suitable for Stable Level Business','price' => '700','is_featured' => '0','is_recommended' => '0','is_default' => '0','is_trial' => '0','status' => '1','days' => '9999','trial_days' => '0','data' => '{"credits":{"value":20000,"overview":"Credit: 20000"},"brands":{"value":-1,"overview":"Unlimited Brands"},"social_accounts":{"value":-1,"overview":"Unlimited Social Account"},"posts":{"value":-1,"overview":"Unlimited Posts"},"analytics":{"value":true,"overview":"Show the analytics of brand contents"},"stock_library":{"value":true,"overview":"Stock library access (Unsplash, Pixels)"},"storage_size":{"value":2000,"overview":"Storage limitation in 2 GB"},"scheduling":{"value":true,"overview":"Allow post scheduling"},"image_editor":{"value":true,"overview":"Access Image Editor"},"stock_content":false}','extra_data' => NULL,'created_at' => '2024-08-02 15:58:36','updated_at' => '2024-08-13 17:22:26')
          );
        
        Plan::insert($plans);
    }
}
