<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Option;

class OptionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $app_url = json_encode(env('APP_URL'));
        $app_url = str_replace('"', '', $app_url);
        $app_url_with_hash = $app_url . '\/#';

        $options = array(
            array('id' => '1', 'key' => 'languages', 'value' => '{"en":"English"}', 'lang' => 'en'),
            array('id' => '2', 'key' => 'base_currency', 'value' => '{"name":"USD","icon":"$","position":"left"}', 'lang' => 'en'),
            array('id' => '3', 'key' => 'tax', 'value' => '0', 'lang' => 'en'),
            array('id' => '4', 'key' => 'invoice_data', 'value' => '{"company_name":"SocialAI","address":"Dhaka","city":"Dhaka","post_code":"1000","country":"Bangladesh"}', 'lang' => 'en'),
            array('id' => '5', 'key' => 'home_page', 'value' => '{"hero":{"icons":[{"title":"Facebook","link":"' . $app_url . '","icon":"\\/demo\\/MeKzP9pAnU0xyoWgqAUs.png"},{"link":"' . $app_url_with_hash . '","title":"Twitter","icon":"\\/demo\\/v7C3G5ThCgAszi4MWwd3.png"},{"link":"' . $app_url_with_hash . '","title":"Instagram","icon":"\\/demo\\/gpng5Q8V9gMswDBQ1kRS.png"},{"link":"' . $app_url_with_hash . '","title":"linkedin","icon":"\\/demo\\/JJ3eM0mykAMYc3RYUXR6.png"},{"link":"' . $app_url_with_hash . '","title":"Tiktok","icon":"\\/demo\\/AGOOmGFxcQu6luMYOnDl.png"}],"title":"Using <span>SocialAI<\\/span> <br\\/> Build your online presence with AI.","subtitle":"Create unique brand identity, generate and schedule content consistently.","btn_one_text":"Our Pricing","btn_one_link":"' . $app_url . '/pricing","btn_two_link":"' . $app_url . '/register","btn_two_text":"Try For Free","title1":"Great [Customer]","title2":"Relationships Start Here.","bottom_bg_overflow":"\\/demo\\/HZl0ALAcVA8VyuplDlHT.png","bottom_img":"\\/demo\\/wYT0PppxHYjtOMy8Vcrs.jpg"},"counter":{"one_title":"350+","one_subtitle":"Team Members","two_title":"10m+","two_subtitle":"Total funding","three_title":"500k","three_subtitle":"Total active user base"},"service":{"title":"Accounting Software <br\\/> That <span>Handles it All.<\\/span>","btn_text":"See All Features","btn_link":"' . $app_url . '/services","bg_top_left_image":"\\/demo\\/G0aVim2berp0JimB13k4.png","bg_img":"\\/demo\\/6bJGiHFldfzcwNBTMZWc.png","bg_bottom_right_image":"\\/demo\\/X9kR0bCYFrUtRbC1v3Qw.png"},"rated":{"title":"Customers have <span>Consistently Rated<\\/span> SocialAI <span>4.9\\/5<\\/span>","reviews":[{"ratting":"5","comment":"the interface is excellent","image":"\\/demo\\/1hCA3Oh7Tko7WnDplZXt.png"},{"ratting":"5","comment":"improvements in every release","image":"\\/demo\\/ZXWl9WCFZSGciW3WsaJm.png"},{"ratting":"5","comment":"the interface is excellent","image":"\\/demo\\/lSAvNxXixd8hxCwIU4Tp.png"}],"btn_text":"Try For Free","btn_link":"' . $app_url . '/register","bg_img":"\\/demo\\/0Sr1Lly9EDfxI6yMiTKK.jpg","bg_bottom_center_image":"\\/demo\\/1kA37blQfGDNdpRG5qW7.png","bg_top_left_image":"\\/demo\\/4b37cEb35NE14gfjMvUG.png","bg_top_right_image":"\\/demo\\/hMggeLSMOPTYj6Q5Ht9J.png"},"cta_s1":{"title":"Manage <span>All your Cards<\\/span> in one Place","sub_title":"Digital products are where it\\u2019s at! There are so many benefits to selling digital products. It\\u2019s easy to get started and they can be extremely profitable  Get Started Free","btn_text":"Get Started Free","btn_link":"' . $app_url . '"},"cta_s2":{"title":"Track and <span>Analyze Sales<\\/span in Real time","sub_title":"Centralize and simplify payments, and get comprehensive insights on your financials TheDevStation.!","list_items":"No hidden fees., 100% security. Guaranteed., No training or maintenance needed"},"integration":{"row_one":[{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/1SFOmCQGewVlSlAbFAMP.png","preview":"\\/demo\\/RDWFhKsZ9NsaGFXyIaPB.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/861xGLJbHKTrJuVdyXV0.png","preview":"\\/demo\\/Fg6FjtmiUTiRWHHCZpUm.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/ckDDxm1PvlgwUvWs6ezc.png","preview":"\\/demo\\/TtbTOQzISqyjVsCGrPcM.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/CCfcttXSzMdafw8AJggV.png","preview":"\\/demo\\/R2TlxMz1TdBZxbLRG3zL.png"},{"preview":"\\/demo\\/QQTMIudTayCGIkR6B2pa.png"}],"btn_text":"See all Integrations","btn_link":"' . $app_url . '/integrations","row_two":[{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/ZvhqcW6H3PV3deBx1BtZ.png","preview":"\\/demo\\/UnsJzSwP796aHyjFcHn9.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/RSUPOGW1mIlr1OG3UEBz.png","preview":"\\/demo\\/Mdi4BGSdVuuSPZWcq6kJ.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/2h3SM9pbw34ASThfHf8f.png","preview":"\\/demo\\/phTebwSNmWXgnruZCX7N.png"},{"link":"' . $app_url_with_hash . '","icon":"\\/uploads\\/24\\/06\\/0Xpe0Ggha9r6U3Q6oMFE.png","preview":"\\/demo\\/ABXg31wo6Urjab2Q3nQC.png"},{"preview":"\\/demo\\/5nnUwqRVmV8iyA6SvgGH.png"}],"top_title":"Integration","title":"Integrated with Your <br\\/> <span>Favourite Apps<\\/span>"},"cta_s3":{"icons":[{"title":"Facebook","link":"' . $app_url_with_hash . '","icon":"\\/demo\\/Fy0jL7dflJob9kzRcuiQ.png"},{"link":"' . $app_url_with_hash . '","title":"Twitter","icon":"\\/demo\\/N9gzRdMUZ9WA2T0VaczK.png"},{"link":"' . $app_url_with_hash . '","title":"Instagram","icon":"\\/demo\\/Mw9USoQ5d0GAQrQZ68X7.png"},{"link":"' . $app_url_with_hash . '","title":"linkedin","icon":"\\/demo\\/9unpwYFzXDTSZtd7Ljef.png"},{"link":"' . $app_url_with_hash . '","title":"Tiktok","icon":"\\/demo\\/IKQAOfJuB5zcoHslCD1Q.png"}],"btn_text":"Try for free","btn_link":"' . $app_url . '/register","list_items":"Free trial, Free migrations, Free trial, Lightning-fast onboarding., All-in-one Social, Boost for your whole team., Free trial, Free migrations, Incredible support, Lightning-fast onboarding., Boost your productivity, Free trial, Free migrations, Free trial, Lightning-fast onboarding., All-in-one Social, Boost for your whole team., Free trial, Free migrations, Incredible support, Lightning-fast onboarding., Cards for your whole team., Free trial, Free migrations,","title":"Get Early Access to SocialAI. <br\\/> <span>Close Your Books Faster and Grow.<\\/span>"}}', 'lang' => 'en'),
            array('id' => '7', 'key' => 'primary_data', 'value' => '{"contact_email":"ruhopicimi@mailinator.com","contact_phone":"123456789","address":"Mollitia voluptatem","socials":{"facebook":"https:\\/\\/www.facebook.com\\/thedevsstation","youtube":"https:\\/\\/www.youtube.com\\/@thedevstation24","twitter":"https:\\/\\/twitter.com\\/","instagram":"https:\\/\\/www.instagram.com\\/","linkedin":"https:\\/\\/www.linkedin.com\\/company\\/the-devstation\\/"},"slogan":"AI-powered social media management—schedule, optimize, and grow your online presence with ease.","copyright_text":"Full Copyright & Design By <a href=\\"\\/\\">@SocialAI<\\/a> 2024","cta_s1":{"title":"Personal & Business Brands From Scratch ✨","sub_title":"STORI\'s Agent will gather information from your URL or ask couple of questions. Then it will turn it into full brand platform.","btn_text":"Get Started Now","btn_link":"' . $app_url . '/pricing","bg_top_right_image":"\\/demo\\/FIPewgBgyeriNxNE1QJd.png","bg_top_right_image2":"\\/demo\\/nwlhPE9oL0bNFd3krVlA.png","bg_bottom_center_image":"\\/demo\\/acFzbkit7k0VhiH2Ja9s.png","bg_overflow_img":"\\/demo\\/5VZqDeSlbbs74rqKR79X.png","bg_img":"\\/demo\\/zD6WQvMu1QI1NeFgkocM.png","bg_top_left_image":"\\/demo\\/532swWA586EkC4E3NZS6.png"},"cta_s2":{"title":"Track and <span>Analyze Sales<\\/span> in Real time","sub_title":"Centralize and simplify payments, and get comprehensive insights on your financials softuch.!","list_items":"No hidden fees., 100% security. Guaranteed., No training or maintenance needed","bg_img":"\\/demo\\/0FPQl8bXtR3hwyrjydkA.png","bg_overflow_image":"\\/demo\\/hpVQXd9qNAPMbjkfYXKe.png","bottom_bg_img":"\\/demo\\/6RfLLQ3zaAnHxX3sn7Po.png"},"footer_cta":{"title":"Evolve your storytelling, with the power of AI","sub_title":"Sign up now and get started with your 5-day free trial.","btn_text":"Get Started Now","btn_link":"' . $app_url . '/pricing","img1":"\\/demo\\/wEcBH8iEXTZ14ojcUZBQ.jpg"},"career_platform":{"items":[{"title":null,"body":null}]},"favicon":"\\/demo\\/qGVah2pqyGbsUJNSfzOS.png","deep_logo":"\\/demo\\/gSL6MppsGVFq1SGbT3mJ.png","logo":"\\/demo\\/B84zp7XuIVeJ8DzEuMsy.png","faq_section":{"top_title":"SUPPORT","title":"Frequently Asked Questions","sub_title":"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium.!","btn_text":"Get In Touch","btn_link":"' . $app_url . '/contact-us","img_1":"\\/demo\\/aH82M6QDDRtr6P7DiMU9.png"}}', 'lang' => 'en'),
            array('id' => '8', 'key' => 'about_page', 'value' => '{"header":{"title":"<span>About<\\/span> <br \\/>  <span>SocialAI<\\/span>","site_name":"thedevstation","image":"\\/demo\\/Y0ojmX0i2c2vNInZErXk.jpg"},"cta_s1":{"features":"Automated Content Creation. | Content Optimization. | Advanced Analytics.","top_title":"OVER 150K+ CLIENT","title":"Why Choose SocialAI","subtitle":"Excepteur sint occaecat cupidatat officia non proident <br \\/> sunt in culpa qui deserunt.!","btn_text":"Contact Us","btn_link":"' . $app_url . '/contact-us","image4":"\\/demo\\/P1EJPJ0ACCGNW4GncqTF.png","image1":"\\/demo\\/hgm5iY7WanRzGU0xi4c8.jpg","image2":"\\/demo\\/F5yEcmP6g4V9ZwrIKNdr.jpg","image3":"\\/demo\\/UzAEdU82Ys9fAL4kIJ9N.jpg","bg_image":"\\/demo\\/NmVhuq3AXMhc5NzhxQOO.png","left_bottom":"\\/demo\\/b815hRB6bJuT8IF3FBXD.png"},"partners":{"title":"Trusted by Thousands Business","sub_title":"More than 100,000+ teams are using SocialAI"},"company":{"top_title":"ABOUT THE COMPANY","left_title":"SocialAI is Made For the Creator.","right_text1":"SocialAI is a cutting-edge application that automates social media content creation, optimization, and analysis using advanced AI. Save time, ensure consistency, and boost engagement effortlessly with SocialAI. Elevate your social media strategy today.","right_text2":"Our clean and simple APIs and transparent SaaS model will give you complete peace of mind.","creators":"11,000<em>+<\\/em>","revenue":"46<em>m<\\/em>","countries":"150<em>+<\\/em>","demo_video":"https:\\/\\/www.youtube.com\\/watch?v=YDXQ_nociO4"},"timeline":{"features":[{"date":"OCT 2019","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"},{"date":"OCT 2019","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"},{"date":"OCT 2019","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"},{"date":"OCT 2019","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"},{"date":"OCT 2020","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"},{"date":"OCT 2021","title":"Our Vision <br> Of a better Way","body":"We envision sales teams having the tools  and talent they need to make remote"}],"top_title":"TIMELINE","title":"Journey Was Started"},"cta_s2":{"title":"Plan, <span>Schedule</span> and Publish With Ease 📅","sub_title":"Schedule and share your content Anywhere. Anytime - with few clicks.","btn_text":"Get Started Now","btn_link":"' . $app_url . '/services"},"career_jobs":{"sub_title":"CURRENT POSITIONS","title":"Join our Growing Team <br> of  SocialAI."}}', 'lang' => 'en'),
            array('id' => '9', 'key' => 'career_page', 'value' => '{"career_platform":{"items":[{"title":"Automated Content","body":"Effortlessly generate engaging posts tailored to your brand."},{"title":"Content Optimization","body":"Enhance post performance with AI-driven insights and A\\/B testing."},{"title":"Advanced Analytics","body":"Understand audience behavior and engagement trends deeply."},{"title":"Personalized Strategies","body":"Tailor content to individual user preferences for maximum impact."}],"top_title":"WHAT WE OFFER","title":"Our Platform","sub_title":"Explore how Avalance can help you toassess security controls continuously.","image1":"\\/demo\\/NeIdTqoCzSe9UdS1CJj4.png"},"career_header":{"title":"Build Your Career With The SocialAI Team","sub_title":"Work without distraction on your own or with your team.","image2":"\\/demo\\/9zXUZuc45d6UEpjHXO2d.jpg","image1":"\\/demo\\/yQNuoXHUp6Z61WUHDrtD.png","image3":"\\/demo\\/LggYSWRVkagXvLuxGIDj.png","image4":"\\/demo\\/1HVIOsYPe4ow7IAIuMbW.png"},"career_jobs":{"title":"Open Positions","sub_title":"Join our Growing Team of SocialAI."},"socials":[]}', 'lang' => 'en'),
            array('id' => '10', 'key' => 'service_page', 'value' => '{"service":{"title":"Accounting Software <br> That <span>Handles it All.<\\/span>","btn_text":"Contact Us","btn_link":"' . $app_url . '/contact-us","bg_bottom_right_image":"\\/demo\\/XTXHTa0J97WF5RfaazJs.png","bg_img":"\\/uploads\\/24\\/07\\/j67myXi1Vru7i3AyNWJP.png","bg_top_left_image":"\\/uploads\\/24\\/07\\/9Ap8psM2TC9jB98u3r63.png","bg_bottom_right_imag":"\\/uploads\\/24\\/07\\/7G6FWKXy3d4sip7oEcDd.png"},"hero":{"title1":"Our Top","title2":"Services","banner_img":"\\/demo\\/BQ7YtQDf9LzmIt4ICezg.jpg"},"sidebar_card":{"title":"Data Analysis Tools & Methods","sub_title":"Lorem Ipsum is simply dummy text of the printing","btn_text":"Work With Us","btn_link":"' . $app_url . '/services","bg_img":"\\/uploads\\/24\\/07\\/k7AvsU0zQH1NtxqvpH0Z.jpg","bottom_img":"\\/uploads\\/24\\/07\\/ztsYMcmNwTUAzZc7512s.png"}}', 'lang' => 'en'),
            array('id' => '11', 'key' => 'contact_page', 'value' => '{"address":"35Park Avenue, Uk","country":"Animi dolorem delec","map_link":"Hic nostrud aut adip","contact_info_text":"Possimus soluta vel","contact_info_number":"+1 (115) 927-8454","live_chat_service_text":"Provident et conseq","live_chat_service_website":"Cumque eius asperior","page_title":"<span>Get In<\\/span> <br \\/> <span>Touch<\\/span>","office_left_name":"Colombia","office_left_address":"Bogota D.C., Colombia, b. a 181 C No. 930 Ap 202","office_center_name":"France","office_center_address":"9 Pearse Street, Kinsale,Cork, P17 AH66, Ireland","office_right_name":"Egypt","office_right_address":"Av. Cordoba 1309, 3\'A, City of Buenos Aires, Egypt","top_title":"CONTACT US","title":"We\'d love to <br \\/> hear From <span> <svg width=\\"44\\" height=\\"44\\" viewBox=\\"0 0 44 44\\" fill=\\"none\\"         xmlns=\\"http:\\/\\/www.w3.org\\/2000\\/svg\\" xmlns:xlink=\\"http:\\/\\/www.w3.org\\/1999\\/xlink\\">         <rect width=\\"44\\" height=\\"44\\" fill=\\"url(#pattern0)\\" \\/>         <defs>             <pattern id=\\"pattern0\\" patternContentUnits=\\"objectBoundingBox\\" width=\\"1\\" height=\\"1\\">                 <use xlink:href=\\"#image0_2106_35\\" transform=\\"translate(-0.425532 -0.170213) scale(0.0212766)\\" \\/>             <\\/pattern>             <image id=\\"image0_2106_35\\" width=\\"83\\" height=\\"66\\"                 xlink:href=\\"data:image\\/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFMAAABCCAYAAAArOOo+AAADcklEQVR4nO2bP0wTURzHP5RqQhyMtyJNTCcTnKCLnVhs4sRmHRk10U0WFhcXiQskuDPhxirRQZMagn8WB1gatTqQiMV\\/qRBM6nB99oDe9Y7+3mvf8T5j03u\\/yyfv97vvK8dQs9ls4hAh0+8bSBNOpiBOpiBOpiBOpiBOpiBOpiBOpiCnWma1AmvzUK\\/JrJeVWcYeqhWovoKnDw9\\/fu1e72ufCplhAhUXLsrUSa3MbgKD5IsyNVMlM4nAIF5Opr71Mk8qUFEoy92LlTJ7FRgkf7X3NRRDtvyeKSkwyKOvcmsN9M6UEuiNQf3z8c8lWxwGUKbkDvTGoHAzfC3JFocBkamjhfNFKC\\/Ag4no70jSN5m6ZiBAadY\\/0SxNR39PKhIpjMrUKRD8ti4v+jtubd6vF4b0vAQDMnULVOSLcHu1XbNbPel5CZqiUb0Gb57oF6hQba1qR81JhWQkUmjZmY+nO0cRaYJtrVi52\\/06HS0OmmTeWm239+sVHRUOt7Wi25z8f62GFgcDJ6B6TV5ssK0V1Ur3p7di7q38kxwMHyd7FduprdW6ceakQse8BBg6OPjbzGaH9aweQVKxndpasTQdr73Bn5flxfj3mYTMyxfv9KzcBS\\/nH\\/XKi37blRfCHwyl2XCRceekQte8BBg+N3Lp\\/tRUgTNn+3eyHDkPo1dg\\/LovdHTc\\/2zvB8wsh0uuVmDlTrJaM8u9328Y2efPNtjc\\/MDE5GV9VRLg5dq7Nop6Lf4DR6ErEiky29vfWF9\\/r7eKBuLkyaPobHFo\\/d18a+sjjcae3kqCJJ2TCulfiY6SAah92rZGZpxzdxg6smWQDMDOznd2d3\\/qrSRE0jmp0D0voSXzT2OP\\/f0D\\/dUEKM2e7Drd8xJaMqvVL\\/z+1dBfTYDJGye7rls6kMC6F7e8XPKWNdHiYKFMSP6SlYkWB0tlerlkMUd3JFJYKROglGB36o5ECmtl5ovxdpypeQkWywQoxHiym5qXYLnMWDvTQCRSWC3Ty0WHeJMtDpbLhOgQb7LFIQUyo0K8qUiksF4mhId4U5FIkQqZnUK86XkJKZEJx0O86XkJKZJ5NMSbjESK1MiEdojvR4tDymTmi61Xr\\/skcyBew5bCy8Fcf96pAFK2M\\/uNkymINf9UZQNuZwriZAriZAriZAriZAriZAriZAriZAryD4xxER8vOFEDAAAAAElFTkSuQmCC\\" \\/>         <\\/defs>     <\\/svg> <\\/span> you.","sub_title":"While we\'re good with smoke signals, there are easier ways to get in touch.","bottom_title":"Book a Demo!","bottom_sub_title":"We will contact again after receive your request in 24h","email":"contact@thedevstation.com","phone":"+1-234-555-0144","facebook":"https:\\/\\/www.qykowytycat.in","twitter":"https:\\/\\/www.feputigabuvyn.org","linkedin":"https:\\/\\/www.dynatepami.com.au","instagram":"https:\\/\\/www.gativufyx.biz","image":"\\/uploads\\/24\\/07\\/FHmZ9dkn2gH5btp11fFQ.png","office_left_img":"\\/uploads\\/24\\/07\\/zmPKB1f1omFNo8N0dwqz.png","office_center_img":"\\/uploads\\/24\\/07\\/tBZrkI01lgmi72Fqm1Rz.png","office_right_img":"\\/uploads\\/24\\/07\\/Ut8UNuPh2C9kFvt2EycO.png","bottom_email_img":"\\/uploads\\/24\\/07\\/IDFzQS2B8YkFiSwiL0ui.png","bottom_phone_img":"\\/uploads\\/24\\/07\\/GH72u0mmndC59cACln8j.png","bottom_address_img":"\\/uploads\\/24\\/07\\/xklRpucyJEjPxk7LXxEp.png","left_img":"\\/uploads\\/24\\/07\\/QPUMEbzk6azmk0KYi82J.png"}', 'lang' => 'en'),
            array('id' => '12', 'key' => 'auth_pages', 'value' => '{"login":{"banner_text":"Welcome To <br> Your SocialAI app.","image2":"\\/uploads\\/24\\/07\\/BHTJqeI6NNJclNvmhmRO.png","image1":"\\/uploads\\/24\\/07\\/Zm9ZNmUqAQqKnbhw08rJ.png","image3":"\\/uploads\\/24\\/07\\/Fm4mMTxiOPXTvhn33FRY.jpg","image4":"\\/uploads\\/24\\/07\\/nK83jgE3iUcEyO54YQQJ.png","image5":"\\/uploads\\/24\\/07\\/b4m8AmozaiiiypHTkVBb.png","bg_image":"\\/uploads\\/24\\/07\\/avZKoGW2SBWcOHMwvdFQ.png"}}', 'lang' => 'en'),
            array('id' => '13', 'key' => 'integration_page', 'value' => '{"hero":{"title":"Integrations","banner_img":"\\/demo\\/RCLtGHQ7AR8q5WAmsH5t.png"},"list":{"title":"What you will get","sub_title":"Take your business to the next level with accessible premium extensions & different features"},"slider":{"btn_text":"See all Integrations","top_title":"Integration","title":"Integrated with Your <span>Favorite Apps<\\/span>","btn_link":"' . $app_url . '/contact-us","bg_img":"\\/demo\\/cya23xRsAvSOq1SXhQAJ.jpg","row_one":[{"preview":"\\/demo\\/YH9I17XNrdM4Iyh80sSB.png"},{"preview":"\\/demo\\/RQrWFxqKx30GokUXHhjY.png"},{"preview":"\\/demo\\/O1vim14DG5O9My7R9wAk.png"},{"preview":"\\/demo\\/QQPvooJDqLZP8255mKrO.png"},{"preview":"\\/demo\\/faaKR9ezWxXrXs86Mrpn.png"}],"row_two":[{"preview":"\\/demo\\/XlvyzaNGnYg2odLQB6pu.png"},{"preview":"\\/demo\\/HYsVFUOatvMekHex3T3G.png"},{"preview":"\\/demo\\/0g2ne1ryXqvhI6Zl4K1v.png"},{"preview":"\\/demo\\/hYJuYtxoCM29dCfrXFvi.png"},{"preview":"\\/demo\\/RiflLLWvbq5LARYKiQgR.png"}]}}', 'lang' => 'en'),
            array('id' => '14', 'key' => 'seo_services', 'value' => '{"title":"Services","description":"Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description  Services seo Description","preview":null,"tags":"Services, seo, tags"}', 'lang' => 'en'),
            array('id' => '15', 'key' => 'seo_home', 'value' => '{"title":"Home","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '16', 'key' => 'seo_about', 'value' => '{"title":"About Us","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '17', 'key' => 'seo_projects', 'value' => '{"title":"Projects","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '18', 'key' => 'seo_team', 'value' => '{"title":"Our Team","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '19', 'key' => 'seo_integrations', 'value' => '{"title":"Integrations","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '20', 'key' => 'seo_pricing', 'value' => '{"title":"Pricing","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '21', 'key' => 'seo_careers', 'value' => '{"title":"Career","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '22', 'key' => 'seo_blogs', 'value' => '{"title":"Blogs","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '23', 'key' => 'seo_contact', 'value' => '{"title":"Contact Us","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '24', 'key' => 'seo_login', 'value' => '{"title":"Login","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '25', 'key' => 'seo_register', 'value' => '{"title":"Register","description":null,"preview":null,"tags":null}', 'lang' => 'en'),
            array('id' => '26', 'key' => 'per_credit_fee', 'value' => '1', 'lang' => 'en'),
            array('id' => '27', 'key' => 'plan', 'value' => '{"overview":"Choose or compare your suitable  plan for your business. Use free trial without Credit Card.","percentage":"25%","plan_data":{"credits":"How many AI Credits you will get","brands":"How Many Brands you can create","social_accounts":"How many Social Accounts you can connect","posts":"Maximum Post Limit","storage_size":"Storage Limit","analytics":"Post Analytics Panel","stock_library":"Stock Library Access","scheduling":"Post Schedule\\/Calender","image_editor":"Post Schedule\\/Calender"},"_method":"put"}', 'lang' => 'en')
        );

        Option::insert($options);
    }
}
