<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBrandAudienceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'category_id' => ['required'],
            'segments' => ['required', 'array'],
            'segments.*.text' => ['required', 'string'],
            'status' => ['required'],
        ];
    }

    public function attributes()
    {
        return [
            'segments.*.text' => 'segment',
        ];
    }
}
