@extends('admin.layouts.master')

@push('style-include')
    <link nonce="{{ csp_nonce() }}" href="{{asset('assets/global/css/datepicker/daterangepicker.css')}}" rel="stylesheet"
        type="text/css" />


@endpush

@section('content')


    <!-- Gallery page -->
    <div class="i-card-md">
        <div class="card-body">
            <div class="row row-cols-xl-4 row-cols-lg-3 row-cols-md-2 row-cols-1 mb-40 g-4">
                <div class="col">
                    <div class="metadata-item">
                        <h6 class="metadata-label">{{translate('Template')}}:</h6>
                        <div class="metadata-value">{{$report->template?->name}}</div>
                    </div>
                </div>
                <div class="col">
                    @php
                        $name = $report->user ? $report->user->name : @$report->admin->name;
                        $role = $report->user ? translate('System User') : translate('Admin');
                    @endphp
                    <div class="metadata-item">
                        <h6 class="metadata-label">{{translate('Generated By')}} :</h6>
                        <div class="metadata-value">
                            <span class="badge bg-success bg-opacity-25 text-success px-3 py-2">{{ $name }}
                                ({{ $role }})</span>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="metadata-item">
                        <h6 class="metadata-label">{{ translate('Generated On') }}:</h6>
                        <div class="metadata-value">{{ get_date_time($report->created_at) }}
                            ({{ diff_for_humans($report->created_at) }})</div>
                    </div>
                </div>

                @if($report->total_images > 0)
                    <div class="col">
                        <div class="metadata-item">
                            <h6 class="metadata-label">{{translate('Total Images')}}:</h6>
                            <div class="metadata-value">
                                <span class="badge bg-success"> {{$report->total_images}}</span>
                            </div>
                        </div>
                    </div>
                @elseif($report->total_videos > 0)
                    <div class="col">
                        <div class="metadata-item">
                            <h6 class="metadata-label">{{translate('Total Videos')}}:</h6>
                            <div class="metadata-value">
                                <span class="badge bg-success"> {{$report->total_videos}}</span>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="d-flex justify-content-between align-items-center flex-wrap mb-3">
                {{-- <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="checkAll">
                    <label class="form-check-label" for="checkAll">
                        Check All
                    </label>
                </div> --}}
                <div id="actionButtons" class="d-none">
                    <button class="i-btn btn--primary btn--sm">Upload Selected</button>
                    <button class="btn btn-danger btn-sm">Delete Selected</button>
                    <button class="btn btn-success btn-sm">Edit Selected</button>
                </div>
            </div>
            <div class="row row-cols-lg-4 row-cols-md-3 row-cols-sm-2 row-cols-1 g-3">
                @if($report)
                    {{-- Images --}}
                    @foreach($report->images ?? [] as $image)
                        <div class="col">
                            <div class="gallery-item position-relative">
                                <img src="{{ $image }}" alt="Gallery Image" class="img-fluid rounded media-box">
                            </div>
                        </div>
                    @endforeach

                    {{-- Videos --}}
                    @foreach($report->videos ?? [] as $video)
                        <div class="col">
                            <div class="gallery-item position-relative">
                                <video class="img-fluid rounded media-box" controls>
                                    <source src="{{ $video }}" type="video/mp4">
                                    {{ translate('Your browser does not support the video tag.') }}
                                </video>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="col">
                        <p>{{ translate('No media found') }}</p>
                    </div>
                @endif
            </div>

        </div>
    </div>


@endsection
@section('modal')
    @include('modal.delete_modal')
    @include('admin.partials.modal.template_report')
@endsection

@push('script-include')
    <script nonce="{{ csp_nonce() }}" src="{{asset('assets/global/js/datepicker/moment.min.js')}}"></script>
    <script nonce="{{ csp_nonce() }}" src="{{asset('assets/global/js/datepicker/daterangepicker.min.js')}}"></script>
    <script nonce="{{ csp_nonce() }}" src="{{asset('assets/global/js/datepicker/init.js')}}"></script>
    <script src="{{asset('assets/global/js/apexcharts.js')}}"></script>
@endpush

@push('script-push')
    <script nonce="{{ csp_nonce() }}">
        (function ($) {
            "use strict";

            $(".select2").select2({});
            $(".user").select2({});


            function updateActionButtons() {
                const checkedCount = document.querySelectorAll('.gallery-checkbox:checked').length;
                const actionButtons = document.getElementById('actionButtons');
                if (checkedCount > 0) {
                    actionButtons.classList.remove('d-none');
                    actionButtons.classList.add('d-block');
                } else {
                    actionButtons.classList.remove('d-block');
                    actionButtons.classList.add('d-none');
                }
            }

            document.getElementById('checkAll').addEventListener('change', function () {
                const checkboxes = document.querySelectorAll('.gallery-checkbox');
                checkboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
                updateActionButtons();
            });

            document.querySelectorAll('.gallery-item').forEach(item => {
                item.addEventListener('click', function (e) {
                    if (e.target.tagName.toLowerCase() !== 'input') {
                        const checkbox = this.querySelector('.gallery-checkbox');
                        checkbox.checked = !checkbox.checked;
                        updateActionButtons();
                    }
                });
            });

            document.querySelectorAll('.gallery-checkbox').forEach(checkbox => {
                checkbox.addEventListener('click', function (e) {
                    e.stopPropagation();
                    updateActionButtons();
                });
            });

        })(jQuery);
    </script>
@endpush
