<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use App\Enums\AiModuleType;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::statement("ALTER TABLE contents MODIFY COLUMN type ENUM(" . implode(',', array_map(fn($value) => "'$value'", AiModuleType::toArray())) . ") DEFAULT '" . AiModuleType::TEXT->value . "' COMMENT 'TEXT : text, IMAGE : image, VIDEO : video'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to previous enum values (exclude the new type)
        $previousValues = array_filter(AiModuleType::toArray(), fn($value) => $value !== 'video');
        DB::statement("ALTER TABLE contents MODIFY COLUMN type ENUM(" . implode(',', array_map(fn($value) => "'$value'", $previousValues)) . ") DEFAULT '" . AiModuleType::TEXT->value . "' COMMENT 'TEXT : text, IMAGE : image'");
    }
};
