<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use App\Enums\AiModuleType;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update the enum column with new values
        DB::statement("ALTER TABLE categories MODIFY COLUMN ai_module_type ENUM(" . implode(',', array_map(fn($value) => "'$value'", AiModuleType::toArray())) . ") DEFAULT '" . AiModuleType::TEXT->value . "'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $previousValues = array_filter(AiModuleType::toArray(), fn($value) => $value !== 'video');
        DB::statement("ALTER TABLE categories MODIFY COLUMN ai_module_type ENUM(" . implode(',', array_map(fn($value) => "'$value'", $previousValues)) . ") DEFAULT '" . AiModuleType::TEXT->value . "'");
    }
};
