<?php

use App\Enums\AiModuleType;
use App\Enums\CategoryDisplay;
use App\Enums\MenuVisibilty;
use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('uid',100)->index()->nullable();
            $table->unsignedBigInteger('parent_id')->index()->nullable()->constrained(table: 'categories');
            $table->unsignedBigInteger('created_by')->index()->nullable()->constrained(table: 'admins');
            $table->unsignedBigInteger('updated_by')->index()->nullable()->constrained(table: 'admins');
            $table->string('title',200)->nullable();
            $table->string('icon',100)->nullable();
            $table->string('slug',200)->nullable();
            $table->string('description',255)->nullable();
            $table->enum('ai_module_type' , AiModuleType::toArray())->default(AiModuleType::TEXT->value);
            $table->string('meta_title',255)->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->enum('status',array_values(StatusEnum::toArray()))->default(StatusEnum::true->status())->comment('Active: 1, Inactive: 0');
            $table->enum('display_in',[array_values(CategoryDisplay::toArray())])->index()->nullable()->comment('0: Blog, 1: Template, 2: Both');
            $table->timestamps();
        });
        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
