<?php
/**
 * WhatsAppTemplateStructureApiData
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use ArrayAccess;
use Infobip\ObjectSerializer;

/**
 * WhatsAppTemplateStructureApiData Class Doc Comment
 *
 * @category Class
 * @description Template structure.
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class WhatsAppTemplateStructureApiData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WhatsAppTemplateStructureApiData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'header' => '\Infobip\Model\WhatsAppHeaderApiData',
        'body' => 'string',
        'footer' => 'string',
        'buttons' => '\Infobip\Model\WhatsAppButtonApiData[]',
        'type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'header' => null,
        'body' => null,
        'footer' => null,
        'buttons' => null,
        'type' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'header' => 'header',
        'body' => 'body',
        'footer' => 'footer',
        'buttons' => 'buttons',
        'type' => 'type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'header' => 'setHeader',
        'body' => 'setBody',
        'footer' => 'setFooter',
        'buttons' => 'setButtons',
        'type' => 'setType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'header' => 'getHeader',
        'body' => 'getBody',
        'footer' => 'getFooter',
        'buttons' => 'getButtons',
        'type' => 'getType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TYPE_TEXT = 'TEXT';
    public const TYPE_MEDIA = 'MEDIA';
    public const TYPE_UNSUPPORTED = 'UNSUPPORTED';



    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_TEXT,
            self::TYPE_MEDIA,
            self::TYPE_UNSUPPORTED,
        ];
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['header'] = $data['header'] ?? null;
        $this->container['body'] = $data['body'] ?? null;
        $this->container['footer'] = $data['footer'] ?? null;
        $this->container['buttons'] = $data['buttons'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['body'] === null) {
            $invalidProperties[] = "'body' can't be null";
        }
        if (!is_null($this->container['footer']) && (mb_strlen($this->container['footer']) > 60)) {
            $invalidProperties[] = "invalid value for 'footer', the character length must be smaller than or equal to 60.";
        }

        if (!is_null($this->container['footer']) && (mb_strlen($this->container['footer']) < 0)) {
            $invalidProperties[] = "invalid value for 'footer', the character length must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['buttons']) && (count($this->container['buttons']) > 3)) {
            $invalidProperties[] = "invalid value for 'buttons', number of items must be less than or equal to 3.";
        }

        if (!is_null($this->container['buttons']) && (count($this->container['buttons']) < 1)) {
            $invalidProperties[] = "invalid value for 'buttons', number of items must be greater than or equal to 1.";
        }

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets header
     *
     * @return \Infobip\Model\WhatsAppHeaderApiData|null
     */
    public function getHeader()
    {
        return $this->container['header'];
    }

    /**
     * Sets header
     *
     * @param \Infobip\Model\WhatsAppHeaderApiData|null $header header
     *
     * @return self
     */
    public function setHeader($header)
    {
        $this->container['header'] = $header;

        return $this;
    }

    /**
     * Gets body
     *
     * @return string
     */
    public function getBody()
    {
        return $this->container['body'];
    }

    /**
     * Sets body
     *
     * @param string $body Template body. Can be registered as plain text or text with placeholders. Placeholders have to be correctly formatted and in the correct order, regardless of other sections. Example: {{1}}, {{2}}, {{3}}...
     *
     * @return self
     */
    public function setBody($body)
    {
        $this->container['body'] = $body;

        return $this;
    }

    /**
     * Gets footer
     *
     * @return string|null
     */
    public function getFooter()
    {
        return $this->container['footer'];
    }

    /**
     * Sets footer
     *
     * @param string|null $footer Template footer. Plain text, up to 60 characters.
     *
     * @return self
     */
    public function setFooter($footer)
    {
        if (!is_null($footer) && (mb_strlen($footer) > 60)) {
            throw new \InvalidArgumentException('invalid length for $footer when calling WhatsAppTemplateStructureApiData., must be smaller than or equal to 60.');
        }
        if (!is_null($footer) && (mb_strlen($footer) < 0)) {
            throw new \InvalidArgumentException('invalid length for $footer when calling WhatsAppTemplateStructureApiData., must be bigger than or equal to 0.');
        }

        $this->container['footer'] = $footer;

        return $this;
    }

    /**
     * Gets buttons
     *
     * @return \Infobip\Model\WhatsAppButtonApiData[]|null
     */
    public function getButtons()
    {
        return $this->container['buttons'];
    }

    /**
     * Sets buttons
     *
     * @param \Infobip\Model\WhatsAppButtonApiData[]|null $buttons Template buttons. Can be either up to 3 `quick reply` buttons or up to 2 `call to action` buttons. Call to action buttons must be unique in type.
     *
     * @return self
     */
    public function setButtons($buttons)
    {
        if (!is_null($buttons) && (count($buttons) > 3)) {
            throw new \InvalidArgumentException('invalid value for $buttons when calling WhatsAppTemplateStructureApiData., number of items must be less than or equal to 3.');
        }
        if (!is_null($buttons) && (count($buttons) < 1)) {
            throw new \InvalidArgumentException('invalid length for $buttons when calling WhatsAppTemplateStructureApiData., number of items must be greater than or equal to 1.');
        }
        $this->container['buttons'] = $buttons;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($type) && !in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
