
<header class="header">
  <?php
            $currencies = site_currencies()->where("code",'!=',session()->get('currency')?->code);
  ?>
  <div class="header-container">
    <div class="d-flex align-items-center gap-lg-3 gap-2">
      <div class="header-icon">
        <button class="btn-icon vertical-menu-btn ripple-dark" data-anim="ripple">
          <i class="las la-bars"></i>
        </button>
      </div>
    </div>
    <div class="d-flex align-items-center gap-lg-3 gap-2">
      <div class="header-icon d-flex">
        <div class="btn-icon fullscreen-btn ripple-dark" data-anim="ripple">
          <i class="las la-expand"></i>
        </div>
      </div>
      <div class="header-icon d-flex">
        <div class="btn-icon ripple-dark" data-anim="ripple">
           <a data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Cache clear')); ?>" href="<?php echo e(route('admin.setting.cache.clear')); ?>">
              <i class="las la-broom"></i>
           </a>
        </div>
      </div>
      <div class="header-icon">
        <div class="btn-icon ripple-dark" data-anim="ripple">
           <a data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Browse frontend')); ?>" target="_blank" href="<?php echo e(url('/')); ?>">
              <i class="las la-globe"></i>
           </a>
        </div>
      </div>
      <?php if(site_settings('database_notifications') ==  App\Enums\StatusEnum::true->status() && check_permission('view_notification')): ?>
          <?php
               $notifications = \App\Models\Notification::where('notificationable_type','App\Models\Admin')
                                                          ->unread()
                                                          ->latest()
                                                          ->take(8)
                                                          ->get();
          ?>

          <div class="header-icon">
            <div class="notification-dropdown">
              <?php if($notifications->count() > 0): ?>
                <span><?php echo e($notifications->count()); ?></span>
              <?php endif; ?>
              <div class="btn-icon dropdown-toggle ripple-dark"  role="button" data-anim="ripple" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="lar la-bell"></i>
              </div>
              <div class="dropdown-menu dropdown-menu-end">
                <div class="dropdown-menu-title">
                  <h6>
                      <?php echo e(translate("Notification")); ?>

                  </h6>
                  <span class="i-badge success"><?php echo e($notifications->count()); ?> <?php echo e(translate("New")); ?>   </span>
                </div>
                <div class="notification-items" data-simplebar>
                    <div class="notification-item">
                        <ul>
                          <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                              <li>
                                <a href="javascript:void(0)" class="read-notification" data-id="<?php echo e($notification->id); ?>" data-href="<?php echo e($notification->url); ?>">
                                  <div class="notify-icon">
                                    <img class="rounded-circle"
                                      src='<?php echo e(imageURL(auth_user()->file,"profile,admin",true)); ?>'
                                      alt="profile.jpg" />
                                  </div>
                                  <div class="notification-item-content">
                                    <h5> <?php echo e(auth_user()->name); ?> <small>
                                        <?php echo e(diff_for_humans($notification->created_at)); ?>

                                      </small></h5>
                                    <p>
                                        <?php echo e(limit_words(strip_tags($notification->message),50)); ?>

                                    </p>
                                  </div>
                                </a>
                              </li>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                              <li class="text-center mx-auto mb-2 no-notification-item">
                                  <p>
                                    <?php echo e(translate("Nothing Found !!")); ?>

                                  </p>
                              </li>
                          <?php endif; ?>
                        </ul>
                    </div>
                </div>
                  <?php if($notifications->count() >0): ?>
                    <div class="dropdown-menu-footer">
                        <a href='<?php echo e(route("admin.notifications")); ?>'>
                           <?php echo e(translate("View All")); ?>

                        </a>
                    </div>
                  <?php endif; ?>
              </div>
            </div>
          </div>
      <?php endif; ?>
       <!-- currency switcher -->
       <div class="header-icon">
        <div class="lang-dropdown">
          <div class="btn-icon btn--text dropdown-toggle" role="button" <?php if($currencies->count() > 0): ?> data-bs-toggle="dropdown" aria-expanded="false" <?php endif; ?> >
            <?php echo e(session()->get('currency')?->code); ?>

          </div>
          <?php if($currencies->count() > 0): ?>
            <div class="dropdown-menu dropdown-menu-end">
              <ul>
                <?php $__currentLoopData = site_currencies()->where("code",'!=',session()->get('currency')->code); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li>
                    <a href="<?php echo e(route('currency.change',$currency->code)); ?>">
                      <?php echo e($currency->code); ?>

                    </a>
                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          <?php endif; ?>
        </div>
      </div>
      <!-- language switcher -->
      <div class="header-icon">
        <?php
          $lang = $languages->where('code',session()->get('locale'));
          $code = count($lang)!=0 ? $lang->first()->code:"en";
          $languages = $languages->where('code','!=',$code)->where('status',App\Enums\StatusEnum::true->status());
        ?>
        <div class="lang-dropdown">
          <div class="btn-icon dropdown-toggle" role="button"  <?php if(!$languages->isEmpty()): ?> data-bs-toggle="dropdown" aria-expanded="false" <?php endif; ?> >
              <img id="header-lang-img" class="flag-img" src="<?php echo e(asset('assets/images/global/flags/'.strtoupper($code ).'.png')); ?>" alt="<?php echo e($code.'.jpg'); ?>" height="20">
          </div>
          <?php if(!$languages->isEmpty()): ?>
            <div class="dropdown-menu dropdown-menu-end">
              <ul>
                  <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                      <a href="<?php echo e(route('language.change',$language->code)); ?>">
                        <img src="<?php echo e(asset('assets/images/global/flags/'.strtoupper($language->code ).'.png')); ?>" alt="<?php echo e($language->code.'.jpg'); ?>" >
                        <?php echo e($language->name); ?>

                      </a>
                    </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          <?php endif; ?>
        </div>
      </div>
     <!-- profile -->
      <div class="header-icon">
        <div class="profile-dropdown">
          <div class="topbar-profile dropdown-toggle" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            <img src='<?php echo e(imageURL(@auth_user()->file,"profile,admin",true)); ?>' alt="<?php echo e(@auth_user()->file->name); ?>">
          </div>
          <div class="dropdown-menu dropdown-menu-end">
            <ul>
              <li>  <span class="dropdown-item"><?php echo e(translate('Welcome')); ?> <?php echo e(auth_user()->name); ?>!</span></li>
              <li>
                  <a class="dropdown-item" href="<?php echo e(route('admin.profile.index')); ?>"> <i class="las la-cog"></i>
                    <?php echo e(translate("Setting")); ?>

                  </a>
              </li>
              <li>
                  <a href="<?php echo e(route('admin.logout')); ?>" class="pointer dropdown-item " >  <i class="las la-sign-out-alt"></i>
                    <?php echo e(translate('logout')); ?>

                  </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>

<?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/partials/topbar.blade.php ENDPATH**/ ?>