<!doctype html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="ltr" data-sidebar="open" color-scheme="light">
<head>
    <meta charset="utf-8" />
    <title><?php echo e(@site_settings("site_name")); ?> <?php echo e(site_settings('title_separator')); ?> <?php echo e(@translate($title)); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link nonce="<?php echo e(csp_nonce()); ?>" rel="shortcut icon" href='<?php echo e(imageURL(@site_logo("favicon")->file,"favicon",true)); ?>' alt="<?php echo e(@site_logo('site_favicon')->file?->name); ?>">
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/bootstrap-icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/backend/css/main.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/toastr.css')); ?>" rel="stylesheet" type="text/css" />
    <?php echo $__env->make('partials.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
    <div class="form-section pt-100 pb-100">
        <div class="container">
            <?php echo $__env->yieldContent('main_content'); ?>
        </div>
    </div>

    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>"src="<?php echo e(asset('assets/global/js/toastify-js.js')); ?>"></script>
    <script  nonce="<?php echo e(csp_nonce()); ?>"src="<?php echo e(asset('assets/global/js/helper.js')); ?>"></script>
    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script-push'); ?>
</body>
</html>


<?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/layouts/auth.blade.php ENDPATH**/ ?>