
<?php

   $featureContent   = get_content("content_feature")->first();
   $featureElements  = get_content("element_feature");
   $featureImageSize  = get_appearance_img_size('feature','content','feature_image');

   $featureImage          = @$featureContent->file?->where("type",'feature_image')->first();


?>

<section class="feature-section pb-110">
  <div class="container">
      <div class="row justify-content-start">
          <div class="col-lg-8 col-xl-6">
              <div class="section-title-one text-start mb-60" data-aos="fade-right" data-aos-duration="1000">
                  <div class="subtitle"><?php echo e(@$featureContent->value->sub_title); ?></div>
                  <h2>  <?php echo (@$featureContent->value->title) ?> </h2>
              </div>
          </div>
      </div>
      <div class="row align-items-center gy-5">
          <div class="col-lg-5">
              <?php if($featureElements->count() > 0): ?>
                  <div class="faq-wrap-two">
                      <div class="accordion" id="featureAccordion">

                        <?php $__currentLoopData = $featureElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button <?php echo e($loop->index != 0 ? 'collapsed' :''); ?>" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-feature-<?php echo e($loop->index); ?>" aria-expanded="true" aria-controls="collapse-feature-<?php echo e($loop->index); ?>">
                                        <?php echo e($feature->value->title); ?>

                                    </button>
                                </h2>
                                <div id="collapse-feature-<?php echo e($loop->index); ?>" class="accordion-collapse collapse <?php echo e($loop->index == 0 ? 'show' :''); ?> "
                                    data-bs-parent="#featureAccordion">
                                    <div class="accordion-body">
                                        <?php echo e($feature->value->description); ?>

                                    </div>
                                </div>
                            </div>
          
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      
                      
                      </div>
                  </div>
              <?php else: ?>
                   <?php echo $__env->make("frontend.partials.not_found", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              <?php endif; ?>
          </div>
          <div class="col-lg-7">
              <img src="<?php echo e(imageURL($featureImage,'frontend',true,$featureImageSize)); ?>" class="rounded-5" alt="<?php echo e(@$featureImage->name ?? 'feature.jpg'); ?>" data-aos="fade-left" data-aos-duration="1000">
          </div>
      </div>
  </div>
</section>
<?php /**PATH D:\laragon\www\beepost\kode\resources\views/frontend/sections/feature.blade.php ENDPATH**/ ?>