<?php use Illuminate\Support\Arr; ?>



<?php $__env->startSection('content'); ?>

    <?php
       $accountTypes = App\Enums\AccountType::toArray();

       if($platform->slug != 'facebook' )  Arr::forget($accountTypes,['GROUP','PAGE']);

       $enumClassPrefix = ucfirst($platform->slug);

       $enumClass  = "App\\Enums\\{$enumClassPrefix}Connection";

       $connectionTypes = App\Enums\ConnectionType::toArray();

       if (class_exists($enumClass))  $connectionTypes = $enumClass::toArray();

       $platforms           = Arr::get(config('settings'),'platforms' ,[]);

       $platformConfig      = Arr::get($platforms,$platform->slug ,null);

       if(isset($platformConfig['unofficial'])) Arr::forget($connectionTypes, App\Enums\ConnectionType::UNOFFICIAL->name);

       if(isset($platformConfig['official']))  Arr::forget($connectionTypes, App\Enums\ConnectionType::OFFICIAL->name);

       $inputs = Arr::get(config('settings.platforms_connetion_field'),$platform->slug,[]);
    ?>

    <form action="<?php echo e(route('admin.social.account.store')); ?>" class="add-listing-form" enctype="multipart/form-data" method="post">
        <?php echo csrf_field(); ?>
        <input hidden name="platform_id" value="<?php echo e($platform->id); ?>">
        <div class="row g-4">
            <div class="col-xl-8 mx-auto">
                <div class="i-card-md">
                    <div class="card--header">
                        <h4 class="card-title">
                            <?php echo e(($platform->name)); ?>

                        </h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <ul class="nav nav-tabs style-1 justify-content-center" role="tablist">
                                    <?php $__currentLoopData = $connectionTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <li class="nav-item" role="presentation">
                                            <button class='nav-link
                                            <?php echo e($loop->index == 0 ? "active" :""); ?>

                                            ' id="lang-tab-<?php echo e(t2k($k)); ?>" data-bs-toggle="pill" data-bs-target="#lang-tab-content-<?php echo e(t2k($k)); ?>" type="button" role="tab" aria-controls="lang-tab-content-<?php echo e(t2k($k)); ?>" aria-selected="true">
                                                <img class="lang-img me-2 rounded w-30" src="<?php echo e(imageURL(@$platform->file,'platform',true)); ?>" alt="<?php echo e($platform->slug.'.jpg'); ?>" height="18">
                                                <span class="align-middle">

                                                <?php echo e(ucfirst(strtolower(k2t($k)))); ?>


                                                </span>
                                            </button>
                                        </li>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <div id="<?php echo e($platform->slug); ?>" class="tab-content">
                                    <?php $__currentLoopData = $connectionTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class='tab-pane fade <?php echo e($loop->index == 0 ? " show active" :""); ?> ' id="lang-tab-content-<?php echo e(t2k($k)); ?>" role="tabpanel">

                                            <?php if( $v == App\Enums\ConnectionType::UNOFFICIAL->value): ?>
                                                <div class="form-inner">
                                                    <label  for="account_type">
                                                        <?php echo e(translate("Account type")); ?>  <span class="text-danger">*</span>
                                                    </label>
                                                    <select name="account_type" id="account_type">
                                                        <?php $__currentLoopData = $accountTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option <?php echo e((old("account_type") && old("account_type")  == $value)  ? "selected" :""); ?> value="<?php echo e($value); ?>">
                                                                      <?php echo e($type); ?>

                                                                </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            <?php endif; ?>

                                            <?php if($v == App\Enums\ConnectionType::UNOFFICIAL->value): ?>

                                                <div class="form-inner d-none page-id" >
                                                    <label  for="page_id">
                                                        <?php echo e(translate("Page ID")); ?>  <span class="text-danger">*</span>
                                                    </label>
                                                    <input  id="page_id" type="text" name="page_id"   placeholder='<?php echo e(translate("Enter Page ID")); ?>'
                                                        value="<?php echo e(old('page_id')); ?>">
                                                </div>

                                                <div class="form-inner d-none  group-id">
                                                    <label  for="group_id">
                                                        <?php echo e(translate("Group ID")); ?>  <span class="text-danger">*</span>
                                                    </label>
                                                    <input  id="group_id" type="text" name="group_id"   placeholder='<?php echo e(translate("Enter Group ID")); ?>'
                                                        value="<?php echo e(old('group_id')); ?>">
                                                </div>
                                                 <?php $__currentLoopData = $inputs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-inner">
                                                        <label  for="<?php echo e($key); ?>">
                                                            <?php echo e(translate(k2t($key))); ?>  <span class="text-danger">*</span>
                                                        </label>
                                                    <input required id="<?php echo e($key); ?>" type="text" name="<?php echo e($key); ?>"   placeholder=' <?php echo e(translate(k2t($key))); ?>'
                                                            value="<?php echo e(old($key)); ?>">
                                                    </div>
                                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <div class="text-center mt-4">
                                                <?php if($v != App\Enums\ConnectionType::UNOFFICIAL->value): ?>
                                                  <div class="d-flex gap-2 justify-content-center">
                                                        <a <?php if($platform->slug == 'facebook'): ?> data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(trans("default.facebook_profile_warning_note")); ?>"  <?php endif; ?>  href='<?php echo e(route("account.connect",[ "guard"=>"admin","medium" => $platform->slug ,"type" => t2k(App\Enums\AccountType::PROFILE->name) ])); ?>' class="i-btn btn--sm info">
                                                            <i class="las la-user-alt me-1"></i>   <?php echo e(translate('Connect Account')); ?>

                                                        </a>
                                                  </div>
                                                <?php else: ?>
                                                    <button type="submit"  class="i-btn btn--md success">
                                                        <i class="las la-link me-1"></i>   <?php echo e(translate('Connect')); ?>

                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            <div class="p-4 mt-4 bg--danger-light rounded-2">
                                                <p class="text--dark"><span class="bg--danger text-white py-0 px-2 d-inline-block me-2 rounded-1"><?php echo e(translate("note")); ?>  :</span>
                                                    <?php if($v != App\Enums\ConnectionType::UNOFFICIAL->value): ?>
                                                       <?php echo e(trans("default.on_click_note")); ?>

                                                    <?php else: ?>
                                                       <?php echo e(trans("default.tokenize_note")); ?>

                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
   </form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <div class="modal fade" id="warning-note-modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="warning-note-modal"   aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <?php echo e(translate('Warning note')); ?>

                    </h5>
                    <button class="close-btn" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>

                <div class="modal-body">

                    <div class="p-4 mt-4 bg--danger-light rounded-2">
                        <p class="text--dark"><span class="bg--danger text-white py-0 px-2 d-inline-block me-2 rounded-1"><?php echo e(translate("note")); ?>  :</span>
                            <?php echo e(trans("default.facebook_profile_warning_note")); ?>

                        </p>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="i-btn btn--md ripple-dark" data-anim="ripple" data-bs-dismiss="modal">
                        <?php echo e(translate("Close")); ?>

                    </button>
                </div>

            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>




<?php $__env->startPush('script-push'); ?>
<script nonce="<?php echo e(csp_nonce()); ?>">
	(function($){
       	"use strict";

            $("#account_type").select2({
                placeholder:"<?php echo e(translate('Select type')); ?>",

	     	})


           inputControl( $("#account_type").val())

            <?php if(old("account_type")): ?>

               inputControl('<?php echo e(old("account_type")); ?>')

            <?php endif; ?>

            $(document).on('change', '#account_type',function(e){

                 var val = $(this).val();

                 inputControl(val)

                e.preventDefault()
            })

            var warningModal = $("#warning-note-modal");

            function inputControl(val){

                if(val  == "<?php echo e(App\Enums\AccountType::GROUP->value); ?>"){
                    $('.page-id').addClass('d-none');
                    $('.group-id').removeClass('d-none');
                 }

                 else if(val  == "<?php echo e(App\Enums\AccountType::PAGE->value); ?>"){
                    $('.page-id').removeClass('d-none');
                    $('.group-id').addClass('d-none');

                 }
                 else{

                    if(warningModal && warningModal.length) warningModal.modal('show')

                    $('.page-id').addClass('d-none');
                    $('.group-id').addClass('d-none');
                 }
            }

	})(jQuery);

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/social/account/create.blade.php ENDPATH**/ ?>