<?php use Illuminate\Support\Arr; ?>

<?php $__env->startPush('style-include'); ?>
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/datepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>


<div class="container-fluid ps-lg-0">
  <div class="row mb-3 g-3">
    <div class="col">
        <div class="page-title-box">
          <h4 class="page-title">
            <?php echo e(translate($title)); ?>

          </h4>
          <div class="page-title-right d-flex justify-content-end align-items-center flex-wrap gap-2">
              <ol class="breadcrumb m-0">
                <li class="breadcrumb-item">
                    <?php
                        $last_cron_run = App\Models\Core\Setting::where('key','last_cron_run')->first();
                    ?>
                    <div class="cron">
                      <?php echo e(translate("Last Cron Run")); ?> : <?php echo e($last_cron_run && $last_cron_run->value ?  diff_for_humans($last_cron_run->value) : "--"); ?>

                    </div>
                </li>
              </ol>
            <form action="<?php echo e(route('admin.home')); ?>" method="get">
              <div class="date-search">
                  <input type="text" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>">
                  <button type="submit" class="me-2"><i class="bi bi-search"></i></button>
                  <a href="<?php echo e(route(Route::currentRouteName())); ?>"  class="i-btn btn--sm danger-transparent">
                    <i class="las la-sync"></i>
                  </a>
              </div>
            </form>
            <button type="button" class="right-menu-btn layout-rightsidebar-btn waves ripple-light">
              <i class="las la-wave-square"></i>
            </button>
          </div>
        </div>
      <div class="row g-3 mb-3">
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
            <div class="i-card-sm style-2 primary">
              <div class="card-info">
                <h3>
                    <?php echo e(Arr::get($data,"total_package",0)); ?>

                </h3>
                <h5 class="title">
                  <?php echo e(translate("Subscription Packages")); ?>

                </h5>
                <a href="<?php echo e(route('admin.subscription.package.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                      <?php echo e(translate("View All")); ?>

                </a>
              </div>
              <div class="d-flex flex-column align-items-end gap-4">
                <div class="icon">
                    <i class="las la-cube"></i>
                </div>
              </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 success">
            <div class="card-info">
              <h3>
                <?php echo e(Arr::get($data,"total_user",0)); ?>

              </h3>
              <h5 class="title">
                <?php echo e(translate("Total Users")); ?>

              </h5>
              <a href="<?php echo e(route('admin.user.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                <?php echo e(translate("View All")); ?>

              </a>
            </div>
            <div class="d-flex flex-column align-items-end gap-4">
              <div class="icon">
                  <i class="las la-user-friends"></i>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
            <div class="i-card-sm style-2 info">
                <div class="card-info">
                  <h3>
                    <?php echo e((Arr::get($data,"total_earning",0))); ?>

                  </h3>
                  <h5 class="title">
                      <?php echo e(translate('Total Earning')); ?>

                  </h5>
                  <a href="<?php echo e(route('admin.subscription.report.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                        <?php echo e(translate("View All")); ?>

                  </a>
                </div>
                <div class="d-flex flex-column align-items-end gap-4">
                  <div class="icon">
                    <i class="las la-wallet"></i>
                  </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 danger">
            <div class="card-info">
              <h3><?php echo e(Arr::get($data,"total_category",0)); ?> </h3>
              <h5 class="title"><?php echo e(translate('Total Category')); ?></h5>
              <a href="<?php echo e(route('admin.category.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
            </div>
            <div class="d-flex flex-column align-items-end gap-4">

              <div class="icon">
                <i class="las la-exchange-alt"></i>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 success">
            <div class="card-info">
            <h3>
                <?php echo e(Arr::get($data,"total_visitor",0)); ?>

              </h3>
              <h5 class="title">
                <?php echo e(translate("Total Visitors")); ?>

              </h5>
              <a href="<?php echo e(route('admin.security.ip.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
            </div>
            <div class="d-flex flex-column align-items-end gap-4">
              <div class="icon">
                <i class="las la-user-friends"></i>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
            <div class="i-card-sm style-2 warning">
                <div class="card-info">
                  <h3>
                    <?php echo e(Arr::get($data,"total_platform",0)); ?>

                  </h3>
                  <h5 class="title">
                    <?php echo e(translate("Social Platform")); ?>

                  </h5>
                  <a href="<?php echo e(route('admin.platform.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
                </div>
                <div class="d-flex flex-column align-items-end gap-4">

                  <div class="icon">
                      <i class="las la-share-alt"></i>
                  </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 info">
              <div class="card-info">
                <h3>
                  <?php echo e(Arr::get($data,"total_template",0)); ?>

                </h3>
                <h5 class="title">
                  <?php echo e(translate("AI Templates")); ?>

                </h5>
                <a href="<?php echo e(route('admin.ai.template.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
              </div>
              <div class="d-flex flex-column align-items-end gap-4">

                <div class="icon">
                  <i class="las la-robot"></i>
                </div>
              </div>
          </div>
        </div>

        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 success">
              <div class="card-info">
                <h3>
                  <?php echo e(Arr::get($data['account_repot'],"total_account",0)); ?>

                </h3>
                <h5 class="title">
                  <?php echo e(translate("Social Accounts")); ?>

                </h5>
                <a href="<?php echo e(route('admin.social.account.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
              </div>
              <div class="d-flex flex-column align-items-end gap-4">

                <div class="icon">
                  <i class="las la-user-tie"></i>
                </div>
              </div>
          </div>
        </div>

        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
          <div class="i-card-sm style-2 success">
              <div class="card-info">
                <h3>
                  <?php echo e(Arr::get($data,"total_transaction",0)); ?>

                </h3>
                <h5 class="title">
                  <?php echo e(translate("Total Transaction")); ?>

                </h5>
                <a href="<?php echo e(route('admin.transaction.report.list')); ?>" class="i-btn btn--sm btn--primary-outline"><?php echo e(translate("View All")); ?></a>
              </div>
              <div class="d-flex flex-column align-items-end gap-4">

                <div class="icon">
                   <i class="las la-euro-sign"></i>
                </div>
              </div>
          </div>
        </div>
      </div>
      <div class="row g-3 mb-3">
        <div class="col-lg-6">
          <div class="i-card-md home home">
            <div class="card--header">
              <h4 class="card-title">
                  <?php echo e(translate("Subscriptions & Income")); ?>

              </h4>

            </div>
            <div class="card-body">
                <div class="row g-2 text-center mb-5">
                  <div class="col-sm-6">
                      <div class="p-3 border border-dashed border-start-0 rounded-2">
                          <h5 class="mb-1">
                              <span>
                                <?php echo e(Arr::get($data['subscription_reports'],"total_subscriptions",0)); ?>

                              </span>
                          </h5>
                          <p class="text-muted mb-0">
                              <?php echo e(translate("Total Subscriptions")); ?>

                          </p>
                      </div>
                  </div>

                  <div class="col-sm-6">
                      <div class="p-3 border border-dashed border-start-0 rounded-2">
                          <h5 class="mb-1"><span>
                            <?php echo e(Arr::get($data['subscription_reports'],"total_income",0)); ?>

                          </span></h5>
                          <p class="text-muted mb-0">
                              <?php echo e(translate("Total Income")); ?>

                          </p>
                      </div>
                  </div>
                </div>
              <div id="subscriptionReport" class="apex-chart"></div>
            </div>
          </div>
        </div>

        <div class="col-lg-6">
          <div class="i-card-md home">
            <div class="card--header">
                <h4 class="card-title">
                    <?php echo e(translate("Social Accounts")); ?>

                </h4>

                <a href="<?php echo e(route('admin.social.account.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                    <?php echo e(translate("View All")); ?>

                </a>
            </div>
            <div class="card-body">
              <div id="accountReport" class="apex-chart"></div>
              <div class="row g-2 mt-4 text-center">

                <!--end col-->
                <div class="col-sm-6">
                    <div class="p-3 border border-dashed border-start-0 rounded-2">
                        <h5 class="mb-1">
                            <span>
                              <?php echo e(Arr::get($data['account_repot'],"active_account",0)); ?>

                            </span>
                        </h5>
                        <p class="text-muted mb-0">
                            <?php echo e(translate("Active")); ?>

                        </p>
                    </div>
                </div>
                <!--end col-->
                <div class="col-sm-6">
                    <div class="p-3 border border-dashed border-start-0 rounded-2">
                        <h5 class="mb-1"><span>
                          <?php echo e(Arr::get($data['account_repot'],"inactive_account",0)); ?>

                        </span></h5>
                        <p class="text-muted mb-0">
                            <?php echo e(translate("Inactive")); ?>

                        </p>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="row g-3 mb-3">


        <div class="col-12">
          <div class="i-card-md home">
            <div class="card--header">
              <h4 class="card-title">
                <?php echo e(translate("Latest Deposits")); ?>

              </h4>

              <a href="<?php echo e(route('admin.deposit.report.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                <?php echo e(translate("View All")); ?>

            </a>
            </div>

            <div class="card-body">
                <div class="table-container">


                     <table>
                      <thead>
                          <tr>
                              <th scope="col">
                                  #
                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Date')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('User')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Method')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('TRX Number')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Receivable Amount')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Payment Amount')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Status')); ?>

                              </th>
                              <th scope="col">
                                  <?php echo e(translate('Options')); ?>

                              </th>
                          </tr>
                      </thead>
                      <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = Arr::get($data,'latest_log',[]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                  <tr>
                                      <td data-label="#">
                                          <?php echo e($loop->iteration); ?>

                                      </td>
                                      <td data-label='<?php echo e(translate("Date")); ?>'>
                                          <?php echo e(get_date_time($report->created_at)); ?>

                                          <div>
                                              <?php echo e(diff_for_humans($report->created_at)); ?>

                                          </div>
                                      </td>
                                      <td data-label='<?php echo e(translate("User")); ?>'>
                                          <a href="<?php echo e(route('admin.user.show',$report->user->uid)); ?>">
                                              <?php echo e($report->user->name); ?>

                                          </a>
                                      </td>
                                      <td data-label='<?php echo e(translate("Payment Method")); ?>'>
                                          <?php echo e($report->method->name); ?>

                                      </td>
                                      <td  data-label='<?php echo e(translate("Trx Code")); ?>'>
                                          <span class="trx-number me-1">
                                              <?php echo e($report->trx_code); ?>

                                          </span>

                                          <span  data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Copy')); ?>" class="icon-btn  success fs-20 pointer copy-trx"><i class="lar la-copy"></i></span>

                                      </td>
                                      <td  data-label='<?php echo e(translate("Final Amount")); ?>'>
                                          <?php echo e(num_format($report->amount,@$report->currency)); ?>

                                      </td>
                                      <td  data-label='<?php echo e(translate("Final Amount")); ?>'>
                                          <?php echo e(num_format($report->final_amount,@$report->method->currency)); ?>

                                      </td>
                                      <td  data-label='<?php echo e(translate("Status")); ?>'>
                                          <?php echo  (payment_status($report->status))  ?>
                                      </td>
                                      <td data-label='<?php echo e(translate("Options")); ?>'>
                                          <div class="table-action">
                                              <a data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Update')); ?>"    href="<?php echo e(route('admin.deposit.report.details',$report->id)); ?>"  class="fs-15 icon-btn info"><i class="las la-pen"></i></a>
                                          </div>
                                      </td>
                                  </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                  <tr>
                                      <td class="border-bottom-0" colspan="9">
                                          <?php echo $__env->make('admin.partials.not_found',['custom_message' => "No Reports found!!"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                      </td>
                                  </tr>
                             <?php endif; ?>
                      </tbody>
                  </table>
                </div>
            </div>
          </div>
        </div>

        <div class="col-xxl-8 col-xl-7">
          <div class="i-card-md home">
            <div class="card--header">
              <h4 class="card-title">
                <?php echo e(translate("Revenue With Charge")); ?>

              </h4>
            </div>
            <div class="card-body">
              <div class="row g-2 mb-4">
                <div class="col-sm-4">
                  <div class="p-3 border text-center border-dashed border-start-0 rounded-2">
                    <h5 class="mb-1">
                        <span>
                            <?php echo e(Arr::get($data['subscription_reports'],"total_income",0)); ?>

                        </span>
                    </h5>
                    <p class="text-muted mb-0">
                      <?php echo e(translate("Income")); ?>

                    </p>
                  </div>
                </div>
                <div class="col-sm-4">
                  <div class="p-3 border text-center border-dashed border-start-0 rounded-2">
                    <h5 class="mb-1">
                        <span>
                            <?php echo e(Arr::get($data,"payment_charge",0)); ?>

                        </span>
                    </h5>
                    <p class="text-muted mb-0">
                      <?php echo e(translate("Payment Charge")); ?>

                    </p>
                  </div>
                </div>
                <div class="col-sm-4">
                  <div class="p-3 border text-center border-dashed border-start-0 rounded-2">
                    <h5 class="mb-1">
                        <span><?php echo e(Arr::get($data,"withdraw_charge",0)); ?></span>
                    </h5>
                    <p class="text-muted mb-0">
                      <?php echo e(translate("Withdraw Charge")); ?>

                  </p>
                  </div>
                </div>
              </div>
              <div id="income" class="apex-chart"></div>
            </div>
          </div>
        </div>

        <div class="col-xxl-4 col-xl-5">
          <div class="i-card-md home">
            <div class="card--header">
              <h4 class="card-title">
                <?php echo e(translate("Latest Subscriptions")); ?>

              </h4>
            </div>
            <div class="card-body">
              <ul class="activity-list">

                <?php $__empty_1 = true; $__currentLoopData = Arr::get($data,'latest_subscriptions',[]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <li>
                      <div class="d-flex align-items-start gap-2">
                        <span class="list-dot"><i class="bi bi-dot"></i></span>
                        <span class="activity-title">
                              <?php echo e(@$subscription->user->name); ?> <?php echo e(translate(" has successfully acquired a new package, completing the payment of")); ?>

                              <?php echo e(num_format(number:$subscription->payment_amount,calC:true)); ?>

                        </span>
                      </div>
                      <span class="time">
                          <?php echo e(diff_for_humans($subscription->created_at)); ?>

                      </span>
                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <li class="d-flex justify-content-center">
                         <?php echo $__env->make('admin.partials.not_found',['custom_message' => "No data found!!"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
          </div>
        </div>
      </div>

      <div class="row g-3 mb-3">
        <div class="col-xxl-4 col-xl-5">
          <div class="i-card-md home">
            <div class="card--header">
              <h4 class="card-title">
                <?php echo e(translate("Plan In Subscription")); ?>

              </h4>
              <a href="<?php echo e(route('admin.subscription.package.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                <?php echo e(translate("View All")); ?>

              </a>
            </div>
            <div class="card-body">
              <div id="planReport" class="apex-chart"></div>
              <div class="row g-2 mt-4 text-center">
                <div class="col-sm-6">
                    <div class="p-3 border border-dashed border-start-0 rounded-2">
                        <h5 class="mb-1">
                            <span>
                              <?php echo e(Arr::get($data,"total_package",0)); ?>

                            </span>
                        </h5>
                        <p class="text-muted mb-0">
                            <?php echo e(translate("Package")); ?>

                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="p-3 border border-dashed border-start-0 rounded-2">
                        <h5 class="mb-1"><span>
                          <?php echo e(Arr::get($data['subscription_reports'],"total_subscriptions",0)); ?>

                        </span></h5>
                        <p class="text-muted mb-0">
                            <?php echo e(translate("Subscriptions")); ?>

                        </p>
                    </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-xxl-8 col-xl-7">
          <div class="i-card-md home">
            <div class="card--header">
              <h4 class="card-title">
                 <?php echo e(translate("Latest Transaction")); ?>

              </h4>

              <a href="<?php echo e(route('admin.transaction.report.list')); ?>" class="i-btn btn--sm btn--primary-outline">
                <?php echo e(translate("View All")); ?>

              </a>
            </div>
            <div class="card-body">
                <div class="table-container">
                  <table >
                    <thead>
                        <tr>
                            <th scope="col">
                              #
                            </th>

                            <th scope="col">
                                <?php echo e(translate('Date')); ?>

                            </th>

                            <th scope="col">
                                <?php echo e(translate('User')); ?>

                            </th>

                            <th scope="col">
                                <?php echo e(translate('TRX Code')); ?>

                            </th>

                            <th scope="col">
                                <?php echo e(translate('Balance')); ?>

                            </th>

                            <th scope="col">
                                <?php echo e(translate('Post Balance')); ?>

                            </th>

                            <th scope="col">
                                <?php echo e(translate('Remark')); ?>

                            </th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = Arr::get($data,'latest_transactiions',[]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                              <tr>
                                  <td data-label="#">
                                      <?php echo e($loop->iteration); ?>

                                  </td>
                                  <td data-label='<?php echo e(translate("Date")); ?>'>
                                      <?php echo e(get_date_time($report->created_at)); ?>

                                  </td>
                                  <td data-label='<?php echo e(translate("User")); ?>'>
                                      <a href="<?php echo e(route('admin.user.show',$report->user->uid)); ?>">
                                          <?php echo e($report->user->name); ?>

                                      </a>
                                  </td>
                                  <td  data-label='<?php echo e(translate("Trx Code")); ?>'>
                                        <?php echo e($report->trx_code); ?>

                                  </td>
                                  <td  data-label='<?php echo e(translate("Credit")); ?>'>
                                      <span class='text--<?php echo e($report->trx_type == App\Models\Transaction::$PLUS ? "success" :"danger"); ?>'>
                                          <i class='las la-<?php echo e($report->trx_type == App\Models\Transaction::$PLUS ? "plus" :"minus"); ?>'></i>
                                            <?php echo e(num_format($report->amount,$report->currency)); ?>

                                      </span>
                                  </td>
                                  <td  data-label='<?php echo e(translate("Post Credit")); ?>'>
                                      <?php echo e(@num_format(
                                          number : $report->post_balance??0,
                                          calC   : true
                                      )); ?>

                                  </td>
                                  <td  data-label='<?php echo e(translate("Remark")); ?>'>
                                      <?php echo e(k2t($report->remarks)); ?>

                                  </td>
                              </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                          <tr>
                              <td class="border-bottom-0" colspan="7">
                                  <?php echo $__env->make('admin.partials.not_found',['custom_message' => "No Reports found!!"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                              </td>
                          </tr>
                         <?php endif; ?>
                    </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-auto layout-rightside-col d-block">
      <div class="overlay"></div>
      <div class="layout-rightside">
          <div class="sidebar-widget">
              <h6 class="widget-title">
                 <?php echo e(translate("Latest credit activity")); ?>

              </h6>

              <?php
                 $creditLogs = Arr::get($data,'credit_logs', collect([]));
              ?>

              <div class="widget-body" >

                  <?php if($creditLogs->count() > 0): ?>
                    <ul class="activity-list">

                       <?php $__currentLoopData = $creditLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                           <?php if($log->user): ?>
                             <?php $user = $log->user; ?>
                              <li class="mb-0">
                                  <div class="acitivity-item align-items-start d-flex">
                                      <div class="flex-shrink-0">
                                          <div class="avatar-sm acitivity-avatar">
                                              <div class="avatar-title rounded-circle bg-secondary">
                                                  <img class="rounded-circle avatar-sm"  src='<?php echo e(imageURL($user->file,"profile,user",true)); ?>' alt="<?php echo e(@$user->file->name?? 'profile.jpg'); ?>">
                                              </div>
                                          </div>
                                      </div>
                                      <div class="flex-grow-1 ms-2">
                                          <h6 class="fs-14 fw-500">
                                              <a href="<?php echo e(route('admin.user.show', $user->uid)); ?>" class="link-secondary">
                                                    <?php echo e($log->user->name); ?>

                                              </a>
                                          </h6>
                                          <p class="mb-0 fs-14">
                                              <?php echo e($log->details); ?>

                                          </p>
                                          <small class="mb-0 text-muted fs-12">
                                              <?php echo e(diff_for_humans($log->created_at)); ?>

                                          </small>
                                      </div>
                                  </div>
                              </li>
                            <?php endif; ?>

                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                  <?php else: ?>
                    <div>
                          <?php echo $__env->make('admin.partials.not_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                  <?php endif; ?>
              </div>
          </div>

          <div class="sidebar-widget">
              <h6 class="widget-title">
                  <?php echo e(translate('Top user with subscription')); ?>

              </h6>
              <div class="widget-body" >

                 <?php
                   $customers = Arr::get($data,'top_customers', collect([]));
                 ?>

                  <?php if($customers->count() > 0): ?>
                    <ul class="top-user-list">
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li>
                              <div class="d-flex align-items-center gap-2 flex-grow-1">
                                <div class="avatar-sm acitivity-avatar">
                                    <div class="avatar-title rounded-5 bg-secondary">
                                      <img class="rounded-circle avatar-sm"  src='<?php echo e(imageURL($customer->file,"profile,user",true)); ?>' alt="<?php echo e(@$customer->file->name?? 'profile.jpg'); ?>">
                                    </div>
                                </div>
                                <h6 class="fs-15 fw-500">

                                    <a href="<?php echo e(route('admin.user.show', $customer->uid)); ?>" class="link-secondary">
                                      <?php echo e($customer->name); ?>

                                  </a>

                                </h6>
                              </div>
                              <div class="flex-shrink-0">
                                  <h6 class="fs-14 fw-500 mb-0">
                                      <?php echo e($customer->subscriptions_count); ?>

                                  </h6>
                              </div>
                          </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  <?php else: ?>
                    <div>
                          <?php echo $__env->make('admin.partials.not_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                  <?php endif; ?>
              </div>
          </div>

          <div class="sidebar-widget">
            <h6 class="widget-title">
                 <?php echo e(translate('Latest reviews')); ?>

            </h6>

              <?php
                 $testimonials          = get_content("element_testimonial");
                 $featureImageSize      = get_appearance_img_size('testimonial','element','image');
              ?>

              <?php if($testimonials->count() > 0): ?>
                <div class="swiper testi-slider">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $testimonials->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                          <div class="swiper-slide">
                            <div class="testi-single">
                                <div class="flex-shrink-0">
                                  <?php $file = $testimonial->file?->first(); ?>
                                  <img  class="avatar-sm rounded material-shadow" src="<?php echo e(imageURL($file,'frontend',true,$featureImageSize)); ?>" alt="<?php echo e(@$file->name?? 'author.jpg'); ?>">
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <div>
                                        <p class="text-muted mb-1 fst-italic text-truncate-two-lines">"<?php echo e($testimonial->value->quote); ?>"</p>

                                    </div>
                                    <div class="text-end mb-0 text-muted">
                                        - <?php echo e(translate('by')); ?> <cite title="Source Title">
                                          <?php echo e($testimonial->value->author); ?>

                                        </cite>
                                    </div>
                                </div>
                            </div>
                          </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
              <?php else: ?>
                  <div>
                      <?php echo $__env->make('admin.partials.not_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                  </div>
              <?php endif; ?>
        </div>

          <div class="sidebar-widget">
              <h6 class="widget-title">
                 <?php echo e(translate('Reviews')); ?>

              </h6>
              <div class="widget-body" >

                    <?php


                       $formatedRatings =   $testimonials->map(fn(App\Models\Admin\Frontend $testimonial) : object =>
                                               (object)['rating'=>$testimonial->value->rating]);

                       $avgRatings      =   $formatedRatings->avg('rating');
                    ?>
                  <h6 class="text-muted mb-3 text-uppercase fw-semibold"></h6>
                  <div class="bg--primary-light px-3 py-2 rounded-2 mb-2">
                      <div class="d-flex align-items-center">
                          <div class="flex-grow-1">
                              <div class="fs-16 align-middle text-warning">
                                   <?php for($i = 0 ; $i<5 ; $i++): ?>
                                       <?php if( $i < round($avgRatings)): ?>
                                           <i class="bi bi-star-fill fs-14"></i>
                                       <?php else: ?>
                                           <i class="bi bi-star"></i>
                                       <?php endif; ?>
                                   <?php endfor; ?>
                              </div>
                          </div>
                          <div class="flex-shrink-0">
                              <h6 class="mb-0 fs-15 text--primary"><?php echo e(round($avgRatings)); ?> <?php echo e(translate('out of 5')); ?> </h6>
                          </div>
                      </div>
                  </div>
                  <div class="text-center">
                      <div class="text-muted"> <?php echo e(translate('Total')); ?>  <span class="fw-medium text-dark"> <?php echo e($testimonials->count()); ?> </span>
                           <?php echo e(translate('reviews')); ?>

                      </div>
                  </div>


                    <?php for( $i = 5 ; $i>0 ; $i-- ): ?>
                        <div class="row align-items-center g-2">
                            <div class="col-auto">
                                <div class="p-2">
                                    <h6 class="mb-0 fs-14"><?php echo e($i); ?> <?php echo e(translate('star')); ?></h6>
                                </div>
                            </div>

                            <div class="col">
                                <div class="p-2">
                                    <div class="progress progress-sm">
                                        <div class="progress-bar ratting-progres-<?php echo e($i); ?>" role="progressbar" aria-valuenow="50.16" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-auto">
                                <div class="p-2">
                                    <span class="mb-0 text-muted fs-14">
                                       <?php echo e($formatedRatings->where('rating',$i)->count()); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endfor; ?>
              </div>
          </div>
      </div>
    </div>
  </div>
</div>

  <?php
        $primaryRgba =  hexa_to_rgba(site_settings('primary_color'));
        $secondaryRgba =  hexa_to_rgba(site_settings('secondary_color'));
        $primary_light = "rgba(".$primaryRgba.",0.1)";
        $primary_light2 = "rgba(".$primaryRgba.",0.702)";
        $primary_light3 = "rgba(".$primaryRgba.",0.5)";
        $primary_light4 = "rgba(".$primaryRgba.",0.3)";
        $secondary_light = "rgba(".$secondaryRgba.",0.1)";
        $symbol = @session()->get('currency')?->symbol ?? base_currency()->symbol;
  ?>
  <?php $__env->stopSection(); ?>

<?php $__env->startPush('script-include'); ?>
  <script src="<?php echo e(asset('assets/global/js/apexcharts.js')); ?>"> </script>
  <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/datepicker/moment.min.js')); ?>"> </script>
  <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/datepicker/daterangepicker.min.js')); ?>"> </script>
  <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/datepicker/init.js')); ?>"> </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-push'); ?>
<script  nonce="<?php echo e(csp_nonce()); ?>">
  "use strict";
    /** account repots */
    var monthlyLabel = <?php echo json_encode(array_keys($data['subscription_reports']['monthly_subscriptions']), 15, 512) ?>;
    var accountValues =  <?php echo json_encode(array_values($data['account_repot']['accounts_by_platform']), 15, 512) ?>;
    var accountLabel =  <?php echo json_encode(array_keys($data['account_repot']['accounts_by_platform']), 15, 512) ?>;
    var options = {
          series: accountValues,
          chart: {
            nonce:"<?php echo e(csp_nonce()); ?>",
            width:380,
            type: 'donut',
            dropShadow: {
            enabled: true,
            color: '#111',
            top: -1,
            left: 3,
            blur: 3,
            opacity: 0.2
          }
        },
        legend: {
            position: 'bottom'
        },
        stroke: {
          width: 0,
        },
        plotOptions: {
          pie: {
            donut: {
              labels: {
                show: true,
                total: {
                  showAlways: true,
                  show: true
                }
              }
            }
          }
        },

        labels: accountLabel,
        dataLabels: {
          dropShadow: {
            blur: 3,
            opacity: 0.8
          }
        },
        fill: {
          opacity: 1,
          pattern: {
            enabled: true,
          },
          colors: ['var(--color-primary)','var(--color-info)','var(--color-success)',  'var(--color-warning)' ,"var(--color-danger)"],

        },
        states: {
          hover: {
            filter: 'none'
          }
        },

        responsive: [{
          breakpoint: 991,
          options: {
            chart: {
              width: "100%",
            }
          }
        }]
    };
    var chart = new ApexCharts(document.querySelector("#accountReport"), options);
    chart.render();

    /** subscription and income */
    var subscriptionIncome = <?php echo json_encode(array_values($data['subscription_reports']['monthly_income']), 15, 512) ?>;
    var subscriptions = <?php echo json_encode(array_values($data['subscription_reports']['monthly_subscriptions']), 15, 512) ?>;
    var options = {
      chart: {
        nonce:"<?php echo e(csp_nonce()); ?>",
        height: 350,
        type: "line",
        toolbar: {
          show: false
        }
      },
      dataLabels: {
        enabled: false,
      },
      colors: ['var(--color-primary)','var(--color-info)','var(--color-success)',  'var(--color-warning)' ,"var(--color-danger)"],

      series: [
        {
          name: "<?php echo e(translate('Subscriptions')); ?>",
          data: subscriptions,
        },
        {
          name: "<?php echo e(translate('Profit')); ?>",
          data: subscriptionIncome,
        },
      ],
      xaxis: {
        categories: monthlyLabel,
      },
      yaxis: [
        {
          title: {
            text: "<?php echo e(translate('Subscription')); ?>",
          },
        },
        {
          opposite: true,
          title: {
            text: "<?php echo e(translate('Income')); ?>",
          }

        },
      ],
      tooltip: {
          shared: false,
          intersect: true,
          y: {
            formatter: function (value, { series, seriesIndex, dataPointIndex, w }) {
              return formatCurrency(value);
            }
          }
        },
      markers: {
        size: 6,
      },
      stroke: {
        width: [4, 4],
      },
      legend: {
        horizontalAlign: "left",
        offsetX: 40,
      },
    };

    var chart = new ApexCharts(document.querySelector("#subscriptionReport"), options);
    chart.render();

    function formatCurrency(value) {
        var symbol =  "<?php echo e($symbol); ?>" ;
        var suffixes = ["", "K", "M", "B", "T"];
        var order = Math.floor(Math.log10(value) / 3);
        var suffix = suffixes[order];
        if(value < 1)
        {return symbol+value}
        var scaledValue = value / Math.pow(10, order * 3);
        return symbol + scaledValue.toFixed(2) + suffix;
    }


 /**  income and charge */

  var paymentCharge = <?php echo json_encode(array_values($data['monthly_payment_charge']), 15, 512) ?>;
  var withdrawCharge = <?php echo json_encode(array_values($data['monthly_withdraw_charge']), 15, 512) ?>;
  var options = {
      chart: {
        nonce:"<?php echo e(csp_nonce()); ?>",
        height: 350,
        type: "line",
        toolbar: {
          show: false
        }
      },
      dataLabels: {
        enabled: false,
      },
      colors: ['var(--color-primary)','var(--color-info)','var(--color-success)',  'var(--color-warning)' ,"var(--color-danger)"],
      series: [
        {
          name: "<?php echo e(translate('Subscriptions Income')); ?>",
          data: subscriptions,
        },
        {
          name: "<?php echo e(translate('Payment Charge')); ?>",
          data: paymentCharge,
        },
        {
          name: "<?php echo e(translate('Withdraw Charge')); ?>",
          data: withdrawCharge,
        },
      ],
      xaxis: {
        categories: monthlyLabel,
      },

      tooltip: {
          shared: false,
          intersect: true,
          y: {
            formatter: function (value, { series, seriesIndex, dataPointIndex, w }) {
              return formatCurrency(value);
            }
          }
        },
      markers: {
        size: 6,
      },
      stroke: {
        width: [4, 4],
      },
      legend: {
        horizontalAlign: "left",
        offsetX: 40,
      },
  };

  var chart = new ApexCharts(document.querySelector("#income"), options);
  chart.render();


  /** plan report */
  var planValues =  <?php echo json_encode(array_values($data['subscription_by_plan']), 15, 512) ?>;
  var planLabel =  <?php echo json_encode(array_keys($data['subscription_by_plan']), 15, 512) ?>;
  var options = {
        series: planValues,
        chart: {
          nonce:"<?php echo e(csp_nonce()); ?>",
          width: 380,
          type: 'donut',
          dropShadow: {
            enabled: true,
            color: '#111',
            top: -1,
            left: 3,
            blur: 3,
            opacity: 0.2
          }
        },

    legend: {
      position: 'bottom'
    },
      stroke: {
        width: 0,
      },
      plotOptions: {
        pie: {
          donut: {
            labels: {
              show: true,
              total: {
                showAlways: true,
                show: true
              }
            }
          }
        }
      },
      labels: planLabel,

      dataLabels: {
        dropShadow: {
          blur: 3,
          opacity: 0.8
        }
      },
      fill: {
        opacity: 1,
        pattern: {
          enabled: true,
        },
        colors: ['var(--color-primary)','var(--color-info)','var(--color-success)',  'var(--color-warning)' ,"var(--color-danger)"],

      },
      states: {
        hover: {
          filter: 'none'
        }
      },
    responsive: [{
        breakpoint: 991,
        options: {
            chart: {
                width: "100%",
            }
        }
    }]
  };
  var chart = new ApexCharts(document.querySelector("#planReport"), options);
  chart.render();




    var swiper = new Swiper(".testi-slider", {
      direction: 'vertical',
      slidesPerView: 2,
      spaceBetween: 10,
      grabCursor: true,
      loop: true,
      mousewheel: {
        eventsTarged: ".swiper-slide",
        sensitivity: 5
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
    });

</script>
<?php $__env->stopPush(); ?>





<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/home.blade.php ENDPATH**/ ?>