<?php
    $currencies = site_currencies()->where("code",'!=',session()->get('currency')->code);
    $lastSegment = collect(request()->segments())->last();

    $lang         = $languages->where('code',session()->get('locale'));
    $code         = count($lang)!=0 ? $lang->first()->code:"en";
    $languages    = $languages->where('status',App\Enums\StatusEnum::true->status())
                              ->where('code','!=', $code);
?>
<header class="header">

    <div class="header-container">
        <div class="d-flex align-items-center gap-3">
            <div class="header-logo d-md-block d-none">
                <a href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(imageUrl(@site_logo('user_site_logo')->file,'user_site_logo',true)); ?>"
                        alt="<?php echo e(@site_logo('user_site_logo')->file->name ?? 'site-logo.jpg'); ?>">
                </a>
            </div>
        </div>

        <div class="sidebar">
            <div class="sidebar-body">
                <div class="mobile-logo-area d-lg-none mb-4">
                    <div class="mobile-logo-wrap">
                        <a href="<?php echo e(route('home')); ?>">

                            <img src="<?php echo e(imageUrl(@site_logo('user_site_logo')->file,'user_site_logo',true)); ?>"
                                alt="<?php echo e(@site_logo('user_site_logo')->file->name); ?>">

                        </a>
                    </div>

                    <div class="closer-sidebar">
                        <i class="bi bi-x-lg "></i>
                    </div>
                </div>

                <div class="sidebar-wrapper">
                    <nav>
                        <ul class="menu-list">
                            <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(url($menu->url)); ?>"
                                        class="menu-link <?php if(!request()->routeIs('home') && URL::current() == url($menu->url)): ?> active <?php endif; ?> ">
                                        <?php echo e($menu->name); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php
                                    $megaMenu              = get_content("content_mega_menu")->first();
                                    $intregrationsContent  = get_content("content_integration")->first();
                                    $intregrationsElements = get_content("element_integration");
                                    $hoverImageSize        = get_appearance_img_size('integration','element','hover_image');
                                    $featureImageSize      = get_appearance_img_size('integration','element','feature_image');


                            ?>

                            <?php if($megaMenu->value->select_input->status == App\Enums\StatusEnum::true->status() ): ?>
                                <li class="menu-item">
                                    <a href="javascript:void(0)" class="menu-link mega-menu-click">
                                        <?php echo e(@$megaMenu->value->title); ?>

                                        <div class="menu-link-icon">
                                            <i class="bi bi-chevron-down"></i>
                                        </div>
                                    </a>

                                    <div class="mega-menu container-lg px-0">
                                        <div class="mega-menu-wrapper">
                                            <div class="row g-4 h-100">
                                                <div class="col-lg-12">
                                                    <div class="mega-menu-right">
                                                        <div class="row g-0 h-100 align-items-center">
                                                            <div class="col-lg-8">
                                                                <div class="social-integra">
                                                                    <h5>
                                                                        <?php echo e(@$intregrationsContent->value->title); ?>

                                                                    </h5>

                                                                    <div class="row">
                                                                        <div class="col-lg-12">
                                                                            <?php if($intregrationsElements->count() > 0): ?>
                                                                                <div class="mega-menu-integra">
                                                                                    <ul class="nav nav-tabs gap-xxl-3 gap-2 border-0" id="customTab" role="tablist">

                                                                                        <?php $__empty_1 = true; $__currentLoopData = $intregrationsElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                                                                            <?php $file = $element->file->where('type',"feature_image")->first(); ?>

                                                                                            <li class="nav-item" role="presentation">
                                                                                                <a href="<?php echo e(route('integration',['slug' =>  make_slug($element->value->title) , 'uid' => $element->uid])); ?>" class="nav-link mega-menu-tab <?php echo e($loop->index == 0 ? 'active' :''); ?> menu-social-item"
                                                                                                    id="tab-<?php echo e($loop->index); ?>-tab"
                                                                                                    data-bs-toggle="tab"
                                                                                                    data-bs-target="#tab-<?php echo e($loop->index); ?>"
                                                                                                    role="tab"
                                                                                                    aria-controls="tab-<?php echo e($loop->index); ?>"
                                                                                                    aria-selected="true">
                                                                                                    <div class="social-item-img">
                                                                                                        <img src="<?php echo e(imageURL($file,'frontend',true,$featureImageSize)); ?>"
                                                                                                            alt="<?php echo e(@$file->name ?? @$element->value->title.'jpg'); ?>"
                                                                                                            loading="lazy">
                                                                                                    </div>

                                                                                                    <div class="content">
                                                                                                        <h6 class="mb-1">
                                                                                                            <?php echo e($element->value->title); ?>

                                                                                                        </h6>
                                                                                                        <p>
                                                                                                            <?php echo e($element->value->short_description); ?>

                                                                                                        </p>
                                                                                                    </div>
                                                                                                </a>
                                                                                            </li>

                                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                                                            <li class="nav-item" role="presentation">
                                                                                                <?php echo $__env->make("frontend.partials.not_found", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                                            </li>
                                                                                        <?php endif; ?>
                                                                                    </ul>
                                                                                </div>
                                                                            <?php else: ?>
                                                                               <?php echo $__env->make("frontend.partials.not_found", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-lg-4 p-3">
                                                                <?php if($intregrationsElements->count() > 0): ?>
                                                                    <div class="tab-content" id="customTabContent">
                                                                        <?php $__currentLoopData = $intregrationsElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php
                                                                                $file = $element->file->where('type',"hover_image")->first();
                                                                            ?>
                                                                            <div class="tab-pane fade <?php echo e($loop->index == 0 ?
                                                                                'show active' :''); ?>  " id="tab-<?php echo e($loop->index); ?>"
                                                                                role="tabpanel" aria-labelledby="tab-<?php echo e($loop->index); ?>-tab">
                                                                                <img src="<?php echo e(imageURL($file,'frontend',true,$hoverImageSize)); ?>"
                                                                                alt="<?php echo e(@$file->name?? 'preview.jpg'); ?>" class="rounded-3">
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                <?php else: ?>
                                                                    <?php echo $__env->make("frontend.partials.not_found", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php endif; ?>

                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="menu-item">
                                    <a href="<?php echo e(route('page',$page->slug)); ?>"
                                        class="menu-link <?php if($lastSegment == $page->slug): ?> active <?php endif; ?> ">
                                        <?php echo e($page->title); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </nav>

                    <div class="sidebar-action d-lg-none">
                        <div class="d-flex align-items-center justify-content-between gap-3">
                            <a href='<?php echo e(route("plan")); ?>' class="i-btn btn--primary-outline btn--lg capsuled">
                                <?php echo e(translate("Get Started")); ?>

                            </a>

                            <?php if(!auth_user('web')): ?>
                                <a href='<?php echo e(route("auth.login")); ?>' class="i-btn btn--secondary btn--lg capsuled">
                                    <?php echo e(translate('Login')); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="sidebar-overlay"></div>
        </div>

        <div class="nav-right d-flex jsutify-content-end align-items-center gap-3">
            <div class="d-lg-none">
                <div class="mobile-menu-btn sidebar-trigger">
                    <i class="bi bi-list"></i>
                </div>
            </div>

            <div class="language">
                <button class="dropdown-toggle lang--toggle" type="button"  <?php if($languages->count() > 0): ?> data-bs-toggle="dropdown" aria-expanded="false" <?php endif; ?>>
                    <img src="<?php echo e(asset('assets/images/global/flags/'.strtoupper($code ).'.png')); ?>" alt="<?php echo e($code.'.jpg'); ?>">
                </button>

                <?php if($languages->count() > 0): ?>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('language.change',$language->code)); ?>">
                                    <img src="<?php echo e(asset('assets/images/global/flags/'.strtoupper($language->code ).'.png')); ?>" alt="<?php echo e($language->code.'jpg'); ?>"> <?php echo e($language->code); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>


            </div>

            <div class="currency">
                <button class=" <?php echo e($currencies->count() > 0 ? 'dropdown-toggle' : ''); ?>  custom--toggle" type="button" <?php if($currencies->count() > 0): ?>  data-bs-toggle="dropdown" aria-expanded="false" <?php endif; ?>>
                    <?php echo e(session()->get('currency')?->code); ?>

                </button>

                <?php if($currencies->count() > 0): ?>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a class="dropdown-item" href="<?php echo e(route('currency.change',$currency->code)); ?>">
                                        <?php echo e($currency->code); ?></a>
                                </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
            </div>

            <?php if(auth_user('web')): ?>
                <div class="dropdown profile-dropdown">
                    <div class="profile-btn dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="true" role="button">
                        <i class="bi bi-three-dots-vertical"></i>
                    </div>

                    <div class="dropdown-menu dropdown-menu-end">
                        <ul>

                            <li class="dropdown-menu-title">
                                <h6>
                                    <?php echo e(translate('Welcome')); ?>,
                                    <span class="user-name">
                                        <?php echo e(auth_user('web')->name); ?>

                                    </span>
                                </h6>
                            </li>

                            <li>
                                <a href="<?php echo e(route('user.home')); ?>" class="dropdown-item">
                                    <i class="bi bi-house"></i> <?php echo e(translate('Dashboard')); ?>

                                </a>
                            </li>

                            <li class="dropdown-menu-footer p-0">
                                <a href="<?php echo e(route('user.logout')); ?>">
                                    <i class="bi bi-box-arrow-left"></i> <?php echo e(translate('Logout')); ?>

                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(!auth_user('web')): ?>
                <div class="d-lg-block d-none">
                    <a href="<?php echo e(route('auth.login')); ?>" class="i-btn btn--dark btn--md capsuled">
                        <?php echo e(translate("Login")); ?>

                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

</header>
<?php /**PATH D:\laragon\www\beepost\kode\resources\views/frontend/partials/header.blade.php ENDPATH**/ ?>