<?php $__env->startSection('main_content'); ?>
    <div class="row form-area justify-content-center align-items-stretch g-0">
        <div class="col-lg-6">
            <div class="form-wrapper auth">
            <div class="background-circles"></div>
                <div class="row gy-4">
                    <div class="col-md-12 text-center">
                        <a href="<?php echo e(route('admin.home')); ?>" class="site-logo">
                            <img src="<?php echo e(imageURL(@site_logo('site_logo')->file,'site_logo',true)); ?>" class="mx-auto" alt="<?php echo e(@site_logo('site_logo')->file->name ?? 'site-logo.jpg'); ?>">
                        </a>
                    </div>
                    <div class="col-md-12 text-center">
                        <h4>
                            <?php echo e(@translate($title)); ?>

                        </h4>
                        <p>
                            <?php echo e(translate('Welcome back! Please login to your account.')); ?>

                        </p>
                    </div>
                </div>
                <form action="<?php echo e(route('admin.authenticate')); ?>" class="login-right-form" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="form-inner">
                                <label for="username" class="form-label">
                                    <?php echo e(translate("Username/Email")); ?> <span class="text-danger" >*</span>
                                </label>
                                <input type="text" name="login" required value="admin"  id="username" placeholder='<?php echo e(translate("Enter Username or email")); ?>'>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-inner password-inner">
                                <label class="form-label" for="password">
                                    <?php echo e(translate("Password")); ?> <span class="text-danger" >*</span>
                                </label>
                                <input required  type="password" value="123123" name="password" class="form-control pe-5 password" placeholder="Enter password" id="password">
                                <i id="toggle-password"  class="bi bi-eye-fill lh-1"></i>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-inner d-flex justify-content-center align-items-center">
                                <div class="checkbox-wrapper">
                                    <input  type="checkbox" name="remember_me"  id="auth-remember-check">
                                    <label for="auth-remember-check">
                                        <?php echo e(translate("Remember me")); ?>

                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <button type="submit" class="i-btn btn--primary btn--lg pill w-100"><?php echo e(translate("Sign In")); ?></button>
                        </div>
                        <div class="col-12 text-center mt-3">
                            <a class="forget-pass"  href="<?php echo e(route('admin.password.request')); ?>"><?php echo e(translate("Forgot password")); ?>?</a>
                        </div>
                    </div>
                </form>
                <div class="auth-footer">
                    <?php echo e(site_settings("copy_right_text")); ?>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-push'); ?>
<script nonce="<?php echo e(csp_nonce()); ?>">
    'use strict'
    $(document).on('click','#toggle-password',function(e){
        e.preventDefault()
        var passwordInput = $("#password");
        var passwordFieldType = passwordInput.attr('type');
        if (passwordFieldType == 'password') {
        passwordInput.attr('type', 'text');
           $("#toggle-password").removeClass('bi bi-eye-fill').addClass('bi bi-eye-slash-fill');
        } else {
        passwordInput.attr('type', 'password');
          $("#toggle-password").removeClass('bi bi-eye-slash-fill').addClass('bi bi-eye-fill');
        }
   });
</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>