<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" class="sr">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <title><?php echo e(@site_settings("user_site_name",site_settings('site_name'))); ?> <?php echo e(site_settings('title_separator')); ?> <?php echo e(Arr::get($meta_data,"title",trans("default.home"))); ?></title>
     <?php echo $__env->make('partials.meta_content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link nonce="<?php echo e(csp_nonce()); ?>" rel="shortcut icon" href="<?php echo e(imageURL(@site_logo('favicon')->file,'favicon',true)); ?>" >
    <link  nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/bootstrap-icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link  nonce="<?php echo e(csp_nonce()); ?> "href="<?php echo e(asset('assets/frontend/css/swiper-bundle.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link  nonce="<?php echo e(csp_nonce()); ?> "href="<?php echo e(asset('assets/frontend/css/venobox.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?> "href="<?php echo e(asset('assets/global/css/nice-select.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?> "href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>"  href="<?php echo e(asset('assets/global/css/aos.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/frontend/css/root.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/frontend/css/common.css')); ?>" rel="stylesheet" type="text/css" />
      <?php if(request()->routeIs('user.*')): ?>
         <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/frontend/css/dashboard.css')); ?>" rel="stylesheet" type="text/css" />
         <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/simplebar.min.css')); ?>" rel="stylesheet" type="text/css" />
      <?php else: ?>
         <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/frontend/css/style.css')); ?>" rel="stylesheet" type="text/css" />
      <?php endif; ?>
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/frontend/css/custom.css')); ?>" rel="stylesheet" type="text/css" />
    <link nonce="<?php echo e(csp_nonce()); ?>" href="<?php echo e(asset('assets/global/css/toastr.css')); ?>" rel="stylesheet" type="text/css" />
    <?php if(site_settings("google_analytics") == App\Enums\StatusEnum::true->status() ): ?>
       <script nonce="<?php echo e(csp_nonce()); ?>" async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(site_settings('google_analytics_tracking_id')); ?>"></script>
        <script nonce="<?php echo e(csp_nonce()); ?>">
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());
          gtag('config', '<?php echo e(site_settings("google_analytics_tracking_id")); ?>');
        </script>
    <?php endif; ?>

    <?php if(site_settings("google_ads") == App\Enums\StatusEnum::true->status() ): ?>
      <script nonce="<?php echo e(csp_nonce()); ?>" async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-<?php echo e(site_settings('google_adsense_publisher_id')); ?>"
          crossorigin="anonymous"></script>
    <?php endif; ?>
    <?php echo $__env->make('partials.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo $__env->yieldPushContent('style-include'); ?>

    <?php echo csp_meta_tag(App\Policies\CustomCspPolicy::class) ?>

    <style nonce="<?php echo e(csp_nonce()); ?>">
        .auth .auth-left{
            z-index: 1;
            overflow: hidden;
        }
        .auth .auth-left::before {
          content: url("<?php echo e(asset('assets/images/default/auth-bg.png')); ?>");
          display: block;
          width: 94%;
          z-index: 2;
          height: 94%;
          position: absolute;
          bottom: 0;
          right: 0;
          z-index: -1;
        }

   </style>
  </head>
  <body>



      <?php if(!request()->routeIs("dos.security") && !request()->routeIs("*auth.*") && site_settings('frontend_preloader') == App\Enums\StatusEnum::true->status()): ?>
        <div class="preloader">
            <div class="dot-wrapper">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        </div>
      <?php endif; ?>

    <?php if(!request()->routeIs("dos.security") &&
        !request()->routeIs("*auth.*") &&
        !request()->routeIs('payment.success') &&
        !request()->routeIs('payment.failed')): ?>
        <?php if(!request()->routeIs('user.*') ): ?>
            <?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php else: ?>
           <?php echo $__env->make('user.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    <?php endif; ?>
    <main class="main" id="main">
         <?php if(request()->routeIs('user.*')): ?>
            <section class='main-wrapper <?php echo e(request()->routeIs("user.plan") || request()->routeIs("user.profile") ? "px-25 pt-25" :""); ?>'>
                <?php echo $__env->yieldContent('content'); ?>
            </section>
         <?php else: ?>
            <?php echo $__env->yieldContent('content'); ?>
         <?php endif; ?>
    </main>
    <?php if(!request()->routeIs("dos.security") &&
        !request()->routeIs("*auth.*") &&
        !request()->routeIs('user.*') &&
        !request()->routeIs('payment.success') &&
        !request()->routeIs('payment.failed')): ?>
      <?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php if(site_settings("cookie") ==  App\Enums\StatusEnum::true->status() && !session()->has('cookie_consent') ): ?>
          <?php echo $__env->make('frontend.partials.cookie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <?php endif; ?>
    <?php endif; ?>
    <?php echo $__env->yieldContent("modal"); ?>

    <script nonce="<?php echo e(csp_nonce()); ?>"  src="<?php echo e(asset('assets/global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script  nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/bootstrap.bundle.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/frontend/js/swiper-bundle.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/frontend/js/venobox.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/nice-select.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/aos.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/purify.js')); ?>"></script>
    <?php if(request()->routeIs('user.*')): ?>
      <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/frontend/js/dashboard.js')); ?>"></script>
      <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/simplebar.min.js')); ?>"></script>
      <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/frontend/js/initiate.js')); ?>"></script>
    <?php else: ?>
      <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/frontend/js/app.js')); ?>"></script>
    <?php endif; ?>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/toastify-js.js')); ?>"></script>
    <script nonce="<?php echo e(csp_nonce()); ?>" src="<?php echo e(asset('assets/global/js/helper.js')); ?>"></script>

    <script nonce="<?php echo e(csp_nonce()); ?>">
      "use strict";

      $(document).on('click', '.mega-menu-click', function (e) {

        e.preventDefault()

      });


       $('img[data-fallback]').on('error', function() {
            var fallbackImage = $(this).data('fallback');
            $(this).attr('src', fallbackImage);
        });

      <?php if(request()->routeIs('user.*')): ?>
         // update status event start
         $(document).on('click', '.status-update', function (e) {
            const id = $(this).attr('data-id')
            const key = $(this).attr('data-key')
            var column = ($(this).attr('data-column'))
            var route = ($(this).attr('data-route'))
            var modelName = ($(this).attr('data-model'))
            var status = ($(this).attr('data-status'))
            const data = {
                'id': id,
                'model': modelName,
                'column': column,
                'status': status,
                'key': key,
                "_token" :"<?php echo e(csrf_token()); ?>",
            }
            updateStatus(route, data)
            })

            // update status method
            function updateStatus(route, data) {
            var responseStatus;
            $.ajax({
                method: 'POST',
                url: route,
                data: data,
                dataType: 'json',
                success: function (response) {
                    if (response) {
                        responseStatus = response.status? "success" :"danger"
                        toastr(response.message,responseStatus)
                        if(response.reload){
                            location.reload()
                        }
                    }
                },
                error: function (error) {

                    handleAjaxError(error);
                                        
                }
            })
            }
      <?php endif; ?>



      $('.social-share').on('click', function (e) {
            e.preventDefault();

            const url = $(this).data('url');
            const name = $(this).data('name');
            const width = $(this).data('width') || 600;
            const height = $(this).data('height') || 450;

            const left = (screen.width / 2) - (width / 2);
            const top = (screen.height / 2) - (height / 2);


            window.open(url, name, `width=${width},height=${height},top=${top},left=${left}`);
        });

      // read notification
      $(document).on('click','.read-notification',function(e){
          e.preventDefault()
          var href = $(this).attr('data-href')
          var id = $(this).attr('data-id')
          readNotification(href,id)

      })

      // read Notification
      function readNotification(href,id){
          $.ajax({
              method:'post',
              url: "<?php echo e(route('user.read.notification')); ?>",
              data:{
                  "_token": "<?php echo e(csrf_token()); ?>",
                  'id':id
              },
              dataType: 'json'
              }).then(response =>{
              if(!response.status){
                  toastr(response.message,'danger')
              }
              else{
                  window.location.href = href
              }}).fail((jqXHR, textStatus, errorThrown) => {
                  toastr(jqXHR.statusText, 'danger');
              });
      }

      // cookie configuration
      $(document).on('click','.cookie-control',function(e){

        e.preventDefault()

          var route = $(this).attr('data-route')

          $.ajax({
                method:'get',
                url: route,
                dataType: 'json',

                success: function(response){

                     toastr(response.message,'success')

                },
                error: function (error){

                    handleAjaxError(error);
                }
            })
      })

      $(document).on('click','.toggle-password',function(e){

        e.preventDefault()

          var parentAuthInput = $(this).closest('.auth-input');
          var passwordField = parentAuthInput.find('.toggle-input');
          var fieldType = passwordField.attr('type') === 'password' ? 'text' : 'password';
          passwordField.attr('type', fieldType);
          var toggleIcon = parentAuthInput.find('.toggle-icon');
          toggleIcon.toggleClass('bi-eye bi-eye-slash');
      });

        $(document).on('click','#genarate-captcha',function(e){
            e.preventDefault()
            var url = "<?php echo e(route('captcha.genarate',[":randId"])); ?>"
            url = (url.replace(':randId',Math.random()))
            document.getElementById('default-captcha').src = url;

        })

        //delete event start
        $(document).on('click', ".delete-item", function (e) {
            e.preventDefault();
            var href = $(this).attr('data-href');
            var message = "<?php echo e(translate('Are you sure you want to remove these record ?')); ?>"
            if (($(this).attr('data-message'))) {
                message = $(this).attr('data-message')
            }

            var cleanContent = DOMPurify.sanitize(message);

            var src = "<?php echo e(asset('assets/images/default/trash-bin.gif')); ?>";
            $('.action-img').attr("src",src)
            $("#action-href").attr("href", href);
            $(".warning-message").html(cleanContent)
            $("#actionModal").modal("show");
        })


          $(document).on('click', ".subscribe-plan", function (e) {
                e.preventDefault();
                var href = $(this).attr('data-href');
                var message = "<?php echo e(translate('Are you sure you want to subscribe in this plan?')); ?>"
                if (($(this).attr('data-message'))) {
                    message = $(this).attr('data-message')
                }

                var cleanContent = DOMPurify.sanitize(message);

                $("#action-href").attr("href", href);
                $(".warning-message").html(cleanContent)
                $("#actionModal").modal("show");
         })


        // Summer note
        $(document).on("click", ".close", function (e) {
            $(this).closest(".modal").modal("hide");
        });
        $(document).on('click', '.note-btn.dropdown-toggle', function (e) {

            var $clickedDropdown = $(this).next();
            $('.note-dropdown-menu.show').not($clickedDropdown).removeClass('show');
            $clickedDropdown.toggleClass('show');
            e.stopPropagation();
        });

        $(document).on('click', function(e) {
            if (!$(e.target).closest('.note-btn.dropdown-toggle').length) {
                $(".note-dropdown-menu").removeClass("show");
            }
        });


        const pagination = document.getElementById("pagination");

        if(pagination){
            if (pagination.children.length > 0) {
                pagination.classList.remove("mt-0");
                pagination.classList.add("mt-5");
            } else {
                pagination.classList.remove("mt-5");
                pagination.classList.add("mt-0");
            }
        }

        $(document).on('click', ".sidemenu-collapse", function(e) {
            e.preventDefault();
        });

    </script>

    <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script-include'); ?>
    <?php echo $__env->yieldPushContent('script-push'); ?>
  </body>
<?php /**PATH D:\laragon\www\beepost\kode\resources\views/layouts/master.blade.php ENDPATH**/ ?>