<?php $__env->startSection('content'); ?>
    <div class="i-card-md">
        <div class="card-body">
            <div class="search-action-area">
                <div class="row g-3">
                    <form hidden id="bulkActionForm" action='<?php echo e(route("admin.platform.bulk")); ?>' method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="bulk_id" id="bulkid">
                        <input type="hidden" name="value" id="value">
                        <input type="hidden" name="type" id="type">
                    </form>
                    <?php if(check_permission('update_platform') ): ?>
                        <div class="col-md-6 d-flex justify-content-start gap-2">
                            <div class="i-dropdown bulk-action mx-0 d-none">
                                <button class="dropdown-toggle bulk-danger" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="las la-cogs fs-15"></i>
                                </button>
                                <ul class="dropdown-menu">
                                    <?php if(check_permission('update_platform')): ?>
                                        <?php $__currentLoopData = App\Enums\StatusEnum::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <button type="button" name="bulk_status" data-type ="status" value="<?php echo e($v); ?>" class="dropdown-item bulk-action-btn" > <?php echo e(translate($k)); ?></button>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-6 d-flex justify-content-end">
                        <div class="search-area">
                            <form action="<?php echo e(route(Route::currentRouteName())); ?>" method="get">
                                <div class="form-inner">
                                    <input name="search" value="<?php echo e(request()->input('search')); ?>" type="search" placeholder="<?php echo e(translate('Search by name ')); ?>">
                                </div>
                                <button class="i-btn btn--sm info">
                                    <i class="las la-sliders-h"></i>
                                </button>
                                <a href="<?php echo e(route(Route::currentRouteName())); ?>"  class="i-btn btn--sm danger">
                                    <i class="las la-sync"></i>
                                </a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <div class="table-container position-relative">
                <?php echo $__env->make('admin.partials.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <table>
                    <thead>
                        <tr>
                            <th scope="col">
                                <?php if(check_permission('update_platform')): ?>
                                    <input class="check-all  form-check-input me-1" id="checkAll" type="checkbox">
                                <?php endif; ?>
                                &nbsp;
                                <?php echo e(translate('Name')); ?>

                            </th>
                            <th scope="col"><?php echo e(translate('Total Accounts')); ?></th>
                            <th scope="col"><?php echo e(translate('Status')); ?></th>
                            <th scope="col"><?php echo e(translate('Feature')); ?></th>
                            <th scope="col"><?php echo e(translate('Is Integrated')); ?></th>
                            <th scope="col"><?php echo e(translate('Options')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label='<?php echo e(translate("Name")); ?>'>
                                    <div class="user-meta-info d-flex align-items-center gap-2">
                                        <?php if( check_permission('update_platform')): ?>
                                            <input  type="checkbox" value="<?php echo e($platform->id); ?>" name="ids[]" class="data-checkbox form-check-input" id="<?php echo e($platform->id); ?>" />
                                        <?php endif; ?>
                                        &nbsp;
                                        <img class="rounded-circle avatar-sm" src='<?php echo e(imageURL(@$platform->file,"platform",true)); ?>' alt="<?php echo e(@$platform->file->name); ?>">
                                        <p>	 <?php echo e(ucfirst($platform->name)); ?></p>
                                    </div>
                                </td>

                                <td data-label='<?php echo e(translate("Total Account")); ?>'>
                                    <span>
                                        <a class="i-badge capsuled success" href="<?php echo e(route('admin.social.account.list',['platform' => $platform->slug])); ?>">
                                          <?php echo e(translate("Total Accounts")); ?> <?php echo e($platform->accounts_count); ?>

                                        </a>
                                    </span>
                                </td>
                                <td data-label='<?php echo e(translate("Status")); ?>'>
                                    <div class="form-check form-switch switch-center">
                                        <input <?php echo e(!check_permission('update_platform') ? "disabled" :""); ?> type="checkbox" class="status-update form-check-input"
                                            data-column="status"
                                            data-route="<?php echo e(route('admin.platform.update.status')); ?>"
                                            data-status="<?php echo e($platform->status == App\Enums\StatusEnum::true->status() ?  App\Enums\StatusEnum::false->status() : App\Enums\StatusEnum::true->status()); ?>"
                                            data-id="<?php echo e($platform->uid); ?>" <?php echo e($platform->status ==  App\Enums\StatusEnum::true->status() ? 'checked' : ''); ?>

                                        id="status-switch-<?php echo e($platform->id); ?>" >
                                        <label class="form-check-label" for="status-switch-<?php echo e($platform->id); ?>"></label>
                                    </div>
                                </td>
                                <td data-label='<?php echo e(translate("Feature")); ?>'>
                                    <div class="form-check form-switch switch-center">
                                        <input <?php echo e(!check_permission('update_platform') ? "disabled" :""); ?> type="checkbox" class="status-update form-check-input"
                                            data-column="is_feature"
                                            data-route="<?php echo e(route('admin.platform.update.status')); ?>"
                                            data-status="<?php echo e($platform->is_feature == App\Enums\StatusEnum::true->status() ?  App\Enums\StatusEnum::false->status() : App\Enums\StatusEnum::true->status()); ?>"
                                            data-id="<?php echo e($platform->uid); ?>" <?php echo e($platform->is_feature ==  App\Enums\StatusEnum::true->status() ? 'checked' : ''); ?>

                                        id="status-switch-feature-<?php echo e($platform->id); ?>" >
                                        <label class="form-check-label" for="status-switch-feature-<?php echo e($platform->id); ?>"></label>
                                    </div>
                                </td>

                                <td data-label='<?php echo e(translate("Integrated")); ?>'>

                                    <?php  echo (intrgration_status($platform->is_integrated))  ?>

                                </td>

                                <td data-label='<?php echo e(translate("Action")); ?>'>
                                    <div class="table-action">
                                        <?php if(check_permission('update_platform') ): ?>
                                            <?php if(check_permission('update_platform')): ?>
                                               <?php if($platform->is_integrated == App\Enums\StatusEnum::true->status()): ?>
                                                <a data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Add Account')); ?>"  href="<?php echo e(route('admin.social.account.create',['platform' => $platform->slug])); ?>" class="fs-15 icon-btn info"><i class="las la-plus"></i>
                                                </a>
                                               <?php endif; ?>

                                                 <?php
                                                     $url = url('/account/' . $platform->slug . '/callback' . ($platform->slug === 'tiktok' ? '' : '?medium=' . $platform->slug));
                                                 ?>

                                                <a  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Configuration')); ?>" data-callback="<?php echo e($url); ?>" href="javascript:void(0);" data-id="<?php echo e($platform->id); ?>"  data-config = "<?php echo e(collect($platform->configuration)); ?>" class="update-config fs-15 icon-btn danger"><i class="las la-tools"></i>
                                                </a>
                                                <a  data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate('Update')); ?>"   href="javascript:void(0);" data-img ='<?php echo e(imageURL(@$platform->file,"platform",true)); ?>'   data-platform = "<?php echo e($platform); ?>" class="update fs-15 icon-btn info"><i class="las la-pen"></i>
                                                </a>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            --
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="border-bottom-0" colspan="7">
                                    <?php echo $__env->make('admin.partials.not_found', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>

    <div class="modal fade" id="platform-modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="platform-modal"   aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">
                        <?php echo e(translate('Update Platform')); ?>

                    </h5>
                    <button class="close-btn" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.platform.update')); ?>" id="platformForm" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <input   hidden name="id" type="text">

                            <div class="col-lg-12">
                                <div class="form-inner">
                                    <label for="image">
                                        <?php echo e(translate('Image')); ?> <small class="text-danger">(<?php echo e(config("settings")['file_path']['platform']['size']); ?>)</small>
                                    </label>
                                    <input data-size = "<?php echo e(config('settings')['file_path']['platform']['size']); ?>" id="image" name="image" type="file" class="preview" >
                                    <div class="mt-2 image-preview-section">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="i-btn btn--md ripple-dark" data-anim="ripple" data-bs-dismiss="modal">
                            <?php echo e(translate("Close")); ?>

                        </button>
                        <button type="submit" class="i-btn btn--md btn--primary" data-anim="ripple">
                            <?php echo e(translate("Submit")); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="config-modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="config-modal"   aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <?php echo e(translate('Update Configuration')); ?>

                    </h5>
                    <button class="close-btn" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.platform.configuration.update')); ?>" id="platformConfigForm" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <input   hidden name="id" type="text">
                            <div class="col-lg-12" id ="configuration">
                            </div>
                            <div class="col-xl-12">
                                <div class="form-inner">
                                    <label for="callbackUrl">
                                        <?php echo e(translate('Callback URL')); ?>

                                    </label>
                                    <div class="input-group">
                                        <input id="callbackUrl"  readonly  type="text" class="form-control" >
                                        <span class="input-group-text pointer copy-text pointer" data-type="modal"  data-text ='' ><i class="las la-copy"></i></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="i-btn btn--md ripple-dark" data-anim="ripple" data-bs-dismiss="modal">
                            <?php echo e(translate("Close")); ?>

                        </button>
                        <button type="submit" class="i-btn btn--md btn--primary" data-anim="ripple">
                            <?php echo e(translate("Submit")); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
<script nonce="<?php echo e(csp_nonce()); ?>">
	(function($){
       	"use strict";

        $(document).on('click','.update',function(e){

            e.preventDefault()
            var platform = JSON.parse($(this).attr('data-platform'));
            var size = ($('#image').attr('data-size')).split("x");
            var modal = $('#platform-modal')
            modal.find('.modal-title').html("<?php echo e(translate('Update Platform')); ?>")
            modal.find('input[name="id"]').val(platform.id)
            modal.modal('show')
        })

        $(document).on('click','.update-config',function(e){
            e.preventDefault()

            var config         = JSON.parse($(this).attr('data-config'));
            var id             = JSON.parse($(this).attr('data-id'));
            var callbackUrl    = ($(this).attr('data-callback'));
            var modal          = $('#config-modal')
            modal.find('input[name="id"]').val(id)
            var html = "";
            for(let i in config){
                var withoutUnderscores =  i.replace(/_/g, ' ');
                var convertedString = withoutUnderscores.replace(/\b\w/g, function (match) {
                    return match.toUpperCase();
                });

                html+= `<div class="form-inner">
                                    <label for="${convertedString}-${i}" class="form-label" >
                                        ${convertedString}  <span  class="text-danger">*</span>
                                    </label>

                                   <input value="${config[i]}" id='${convertedString}-${i}' required type="text" name="configuration[${i}]">
                                </div>`;

            }

            $("#configuration").html(html)
            $('#callbackUrl').val(callbackUrl)
            $('.copy-text').attr('data-text',callbackUrl)
            modal.modal('show')
        })

	})(jQuery);

</script>
<?php $__env->stopPush(); ?>






<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/platform/list.blade.php ENDPATH**/ ?>