<?php
   $footer        = get_content("content_footer")->first();
   $footerbg      = $footer->file->where("type",'footer_background')->first();
   $footerbgSize  = get_appearance_img_size('footer','content','footer_background');
   $paymentImg      = $footer->file->where("type",'payment_image')->first();
   $paymentImgSize  = get_appearance_img_size('footer','content','payment_image');
   $icons         = get_content("element_social_icon");
   $buttons       = get_content("element_footer");
   $blogs        =get_feature_blogs()->take(2);
   $services = get_content("element_service")->take(4);
?>

<footer>
  <div class="container">
    <div class="footer-top pt-110 pb-110">
        <div class="row justify-content-center">
          <div class="col-lg-9">
              <div class="footer-top-content" data-aos="fade-up" data-aos-duration="1000">
                   <img src="<?php echo e(imageURL($footerbg,'frontend',true,$footerbgSize)); ?>" alt="<?php echo e(@$footerbg->name ?? 'footer-bg.jpg'); ?>" class="footer-top-img">
                    <h2>
                       <?php echo e(@$footer->value->title); ?>

                    </h2>
                    <p> <?php echo e(@$footer->value->description); ?> </p>


                    <?php if( $buttons->count() > 0): ?>
                      <div class="d-flex justify-content-center align-items-center gap-3 flex-wrap">
                            <?php $__currentLoopData = $buttons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $button): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <a href="<?php echo e(@$button->value->button_URL); ?>" class="i-btn btn--lg btn--primary capsuled">
                                    <?php echo e(@$button->value->button_name); ?>

                                    <span>
                                        <i class=" <?php echo e(@$button->value->button_icon); ?>"></i>
                                    </span>
                                  </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                    <?php endif; ?>
              </div>
          </div>
        </div>
    </div>
  </div>

  <div class="container-fluid px-lg-0 px-md-4">
    <div class="news-letter-area">
        <div class="newsletter-wrapper">
          <form  action="<?php echo e(route('subscribe')); ?>" method="post">
             <?php echo csrf_field(); ?>
              <input name="email" type="email" placeholder="<?php echo e(translate('Enter your email')); ?>">
              <button class="i-btn btn--lg btn--primary capsuled">
                   <?php echo e(translate("SUBSCRIBE")); ?>

                  <span><i class="bi bi-arrow-up-right"></i></span>
              </button>
          </form>
        </div>
    </div>
  </div>

  <div class="container">
      <div class="footer-bottom">
        <div class="row gy-5">
          <?php if($menus->count() > 0): ?>
              <div class="col-lg-3 col-md-6 col-sm-6 col-6">
                  <h4 class="footer-title">
                     <?php echo e(translate('Quick link')); ?>

                  </h4>
                  <ul class="footer-list">
                     <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(url($menu->url)); ?>">
                                    <?php echo e($menu->name); ?>

                                </a>
                            </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
          <?php endif; ?>

          <?php if($pages->count() > 0): ?>
              <div class="col-lg-3 col-md-6 col-sm-6 col-6">
                  <h4 class="footer-title">
                      <?php echo e(translate("Information")); ?>

                  </h4>
                  <ul class="footer-list">
                      <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li>
                              <a href="<?php echo e(route('page',$page->slug)); ?>">
                                <?php echo e($page->title); ?>

                              </a>
                          </li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
          <?php endif; ?>

          <?php if($services->count() > 0): ?>
              <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                  <h4 class="footer-title">Services</h4>
                  <ul class="footer-list">
                      <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <li><a href="<?php echo e(route('service',['slug' => make_slug($service->value->title) ,'uid'=> $service->uid  ])); ?>"> <?php echo e(limit_words($service->value->title,25)); ?></a></li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
          <?php endif; ?>

           <?php if($blogs->count() > 0): ?>
              <div class="col-lg-3 col-md-6 col-sm-6 col-12">
                  <h4 class="footer-title">
                     <?php echo e(translate("Blogs")); ?>

                  </h4>
                  <ul class="footer-list">
                       <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li>
                            <a href="<?php echo e(route('blog.details',$blog->slug)); ?>"><?php echo e(limit_words($blog->title,28)); ?></a>
                            <span>
                                <?php echo e(get_date_time($blog->created_at,"F j, Y")); ?>

                            </span>
                        </li>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
           <?php endif; ?>

        </div>
      </div>

      <div class="copyright-area d-flex justify-content-lg-between justify-content-center align-items-center flex-wrap gap-4">

           <?php if($icons->count() > 0): ?>
              <div class="footer-social">
                  <ul>
                       <?php $__currentLoopData = $icons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $icon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a target="_blank" href="<?php echo e($icon->value->button_url); ?>"><i class="<?php echo e($icon->value->icon); ?>"></i></a></li>
                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                  </ul>
              </div>
            <?php endif; ?>

            <div class="payment-image">
                <img src="<?php echo e(imageURL($paymentImg ,'frontend',true,$paymentImgSize)); ?>" alt="<?php echo e(@$paymentImg->name ?? 'payment.jpg'); ?>">
            </div>


            <div class="copyright">
               <p class="mb-0 text-white opacity-75 fs-14 lh-1"><?php echo e(site_settings("copy_right_text")); ?></p>
            </div>
      </div>
  </div>
</footer>


<?php /**PATH D:\laragon\www\beepost\kode\resources\views/frontend/partials/footer.blade.php ENDPATH**/ ?>