
<div class="sidebar">
  <div class="sidebar-logo">
    <a href="<?php echo e(route('admin.home')); ?>">
      <img
        src='<?php echo e(imageURL(@site_logo("site_logo")->file,"site_logo",true)); ?>'
        alt="site-logo.jpg" />
    </a>

  </div>

  <div class="sidebar-menu-container" data-simplebar>
    <ul class="sidebar-menu">

        <?php if(check_permission('view_dashboard')): ?>
          <li class="sidebar-menu-title">  <?php echo e(trans('default.home')); ?></li>
            <li class="sidebar-menu-item">
                <a class="sidebar-menu-link <?php echo e(sidebar_awake('admin.home')); ?>" data-anim="ripple" href='<?php echo e(route("admin.home")); ?>' aria-expanded="false">
                    <span><i class="las la-chart-line"></i></span>
                    <p> <?php echo e(translate("Dashboard")); ?></p>
                </a>
            </li>
        <?php endif; ?>

        <?php if( check_permission('view_role') ||  check_permission('view_staff') ): ?>
          <li class="sidebar-menu-item">
              <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#role_staff" role="button"
                aria-expanded="false" aria-controls="role_staff">
                <span><i class="las la-user-lock"></i></span>
                  <p>
                    <?php echo e(translate('Access Control')); ?>

                  </p>
                  <small >
                    <i class="las la-angle-down"></i>
                  </small>
              </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.role.*','admin.staff.*'],'drop_down')); ?> " id="role_staff">
              <ul class="sub-menu">
                <?php if(check_permission('view_role')): ?>
                  <li class="sub-menu-item">
                      <a class="sidebar-menu-link <?php echo e(sidebar_awake('admin.role.*')); ?>" href="<?php echo e(route('admin.role.list')); ?>">
                        <span></span>
                          <p>
                            <?php echo e(translate('Roles & Permissions')); ?>

                          </p>
                      </a>
                  </li>
                <?php endif; ?>

                <?php if(check_permission('view_staff')): ?>
                  <li class="sub-menu-item">
                      <a class="sidebar-menu-link  <?php echo e(sidebar_awake('admin.staff.*')); ?>" href="<?php echo e(route('admin.staff.list')); ?>">
                          <span></span>
                          <p>
                            <?php echo e(translate('Staffs')); ?>

                          </p>
                      </a>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
          </li>
        <?php endif; ?>



        <?php if(check_permission('view_package')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#packages" role="button"
              aria-expanded="false" aria-controls="packages">
              <span><i class="lab la-hornbill"></i></span>
              <p>
                <?php echo e(translate('Subscription Services')); ?>

              </p>
              <small >
                <i class="las la-angle-down"></i>
              </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.subscription.package.*'],'drop_down')); ?> " id="packages">
              <ul class="sub-menu">
                <li class="sub-menu-item">
                  <a class="sidebar-menu-link <?php echo e(sidebar_awake(['admin.subscription.package.list' ,'admin.subscription.package.edit'])); ?>" href="<?php echo e(route('admin.subscription.package.list')); ?>">
                    <span></span>
                      <p>
                        <?php echo e(translate('Packages')); ?>

                      </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class="sidebar-menu-link  <?php echo e(sidebar_awake('admin.subscription.package.create')); ?>" href="<?php echo e(route('admin.subscription.package.create')); ?>">
                    <span></span>
                    <p>
                      <?php echo e(translate('Add New')); ?>

                    </p>
                  </a>
                </li>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        <?php if(check_permission('view_account') || check_permission('view_platform')): ?>
         <li class="sidebar-menu-title">  <?php echo e(translate('Social Media')); ?></li>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#socialAccount" role="button"
              aria-expanded="false" aria-controls="socialAccount">
            <span><i class="las la-tools"></i></span>
              <p>
                <?php echo e(translate('Accounts')); ?>

              </p>
              <small >
                  <i class="las la-angle-down"></i>
              </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.platform.*','admin.social.account.*'],'drop_down')); ?> " id="socialAccount">
              <ul class="sub-menu">
                <?php if(check_permission('view_platform')): ?>
                  <li class="sub-menu-item">
                      <a  href='<?php echo e(route("admin.platform.list")); ?>' class='sidebar-menu-link <?php echo e(sidebar_awake("admin.platform.list")); ?> '>
                        <span></span>
                        <p><?php echo e(translate('Platforms')); ?></p>
                      </a>
                  </li>
                <?php endif; ?>

                <?php if(check_permission('view_account')): ?>
                  <li class="sub-menu-item">
                      <a  href="<?php echo e(route('admin.social.account.list',['platform' =>'facebook'])); ?>"  class='sidebar-menu-link <?php echo e(sidebar_awake("admin.social.account.*")); ?>'>
                          <span></span>
                          <p><?php echo e(translate('Accounts')); ?></p>
                      </a>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
          </li>
        <?php endif; ?>

        <?php if(check_permission('view_post')): ?>
          <li class="sidebar-menu-item">
              <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#socialFeed" role="button"
                aria-expanded="false" aria-controls="socialFeed">
              <span><i class="las la-paper-plane"></i></span>
                <p>
                  <?php echo e(translate('Posts')); ?>

                </p>
                <small >
                    <i class="las la-angle-down"></i>
                </small>
              </a>
              <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.social.post.*'],'drop_down')); ?> " id="socialFeed">
                <ul class="sub-menu">
                  <?php if(check_permission('view_account')): ?>
                  <li class="sub-menu-item">
                    <a  href="<?php echo e(route('admin.social.post.analytics')); ?>"  class='sidebar-menu-link <?php echo e(sidebar_awake("admin.social.post.analytics")); ?>'>
                        <span></span>
                        <p><?php echo e(translate('Analytics')); ?></p>
                    </a>
                  </li>
                    <li class="sub-menu-item">
                        <a  href="<?php echo e(route('admin.social.post.list')); ?>"  class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.social.post.list","admin.social.post.show"])); ?>'>
                            <span></span>
                            <p><?php echo e(translate('All Post')); ?></p>
                        </a>
                    </li>
                    <li class="sub-menu-item">
                        <a  href="<?php echo e(route('admin.social.post.create')); ?>"  class='sidebar-menu-link <?php echo e(sidebar_awake("admin.social.post.create")); ?>'>
                            <span></span>
                            <p><?php echo e(translate('Create New')); ?></p>
                        </a>
                    </li>
                  <?php endif; ?>
                </ul>
              </div>
          </li>
        <?php endif; ?>

        <?php if(check_permission('view_user')): ?>
            <li class="sidebar-menu-title">
              <?php echo e(translate('User Statistics & Support')); ?>

            </li>
            <li class="sidebar-menu-item">
              <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#users" role="button" aria-expanded="false" aria-controls="users">
                <span><i class="las la-users-cog"></i></span>
                <p>
                    <?php echo e(translate('Manage Users')); ?>

                </p>
                <small >
                    <i class="las la-angle-down"></i>
                </small>
              </a>
              <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.user.*'],'drop_down')); ?> " id="users">
                <ul class="sub-menu">

                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.user.statistics"])); ?>'  href='<?php echo e(route("admin.user.statistics")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('Statistics')); ?>

                      </p>
                    </a>
                  </li>


                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.user.list","admin.user.show"])); ?>'  href='<?php echo e(route("admin.user.list")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('All Users')); ?>

                      </p>
                    </a>
                  </li>
                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.user.active")); ?>'  href='<?php echo e(route("admin.user.active")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('Active Users')); ?>

                      </p>
                    </a>
                  </li>
                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.user.banned")); ?>'  href='<?php echo e(route("admin.user.banned")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('Banned Users')); ?>

                      </p>
                    </a>
                  </li>

                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.user.kyc.verfied")); ?>'  href='<?php echo e(route("admin.user.kyc.verfied")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('KYC Verified')); ?>

                      </p>
                    </a>
                  </li>

                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.user.kyc.banned")); ?>'  href='<?php echo e(route("admin.user.kyc.banned")); ?>'>
                      <span></span>
                      <p>
                          <?php echo e(translate('KYC Banned')); ?>

                      </p>
                    </a>
                  </li>
                </ul>
              </div>
            </li>
        <?php endif; ?>

        <?php if(check_permission('view_ticket')): ?>
            <li class="sidebar-menu-item">
              <a
                class='sidebar-menu-link <?php echo e(sidebar_awake("admin.ticket.*")); ?>'
                data-anim="ripple"
                href='<?php echo e(route("admin.ticket.list")); ?>'
                aria-expanded="false">
                <span><i class="las la-question"></i></span>
                <p> <?php echo e(translate("Support Tickets")); ?>

                    <?php if($pending_tickets > 0): ?>
                      <span  data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Pending tickets')); ?>" class="i-badge danger"><?php echo e($pending_tickets); ?></span>
                    <?php endif; ?>
                </p>
              </a>
            </li>
        <?php endif; ?>

        <?php if(check_permission('view_report')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#report" role="button"
              aria-expanded="false" aria-controls="report">
              <span><i class="las la-stream"></i></span>
                <p>
                  <?php echo e(translate('Report')); ?>

                    <?php if($pending_deposits > 0 || $pending_withdraws > 0 || $pending_kycs > 0  ): ?>
                      <span  data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Pending reports')); ?>"  class="i-badge danger">
                          <i class="las la-info"></i>
                      </span>
                    <?php endif; ?>
                </p>
                <small >
                  <i class="las la-angle-down"></i>
                </small>
            </a>
            <div class='side-menu-dropdown collapse <?php echo e(sidebar_awake(["admin.template.report.*","admin.subscription.report.*","admin.payment.report.*","admin.transaction.report.*","admin.credit.report.*","admin.withdraw.report.*","admin.deposit.report.*" ,"admin.affiliate.report.*","admin.kyc.report.*","admin.webhook.*"],"drop_down")); ?>' id="report">
              <ul class="sub-menu">
                <li class="sub-menu-item">
                  <a  href='<?php echo e(route("admin.template.report.list")); ?>'  class='sidebar-menu-link <?php echo e(sidebar_awake("admin.template.report.list")); ?>'>
                      <span></span>
                      <p>
                        <?php echo e(translate("Template Reports")); ?>

                      </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.subscription.report.*")); ?>'  href='<?php echo e(route("admin.subscription.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Subscription Reports')); ?>

                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.credit.report.*")); ?>'  href='<?php echo e(route("admin.credit.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Credit Reports')); ?>

                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.deposit.report.*")); ?>'  href='<?php echo e(route("admin.deposit.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Deposit Reports')); ?>


                      <?php if($pending_deposits > 0 ): ?>
                         <span  data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Pending deposit')); ?>" class="i-badge danger"><?php echo e($pending_deposits); ?></span>
                      <?php endif; ?>
                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.withdraw.report.*")); ?>'  href='<?php echo e(route("admin.withdraw.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Withdraw Reports')); ?>


                      <?php if($pending_withdraws > 0 ): ?>
                          <span   data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Pending withdraws')); ?>" class="i-badge danger"><?php echo e($pending_withdraws); ?></span>
                      <?php endif; ?>
                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.affiliate.report.*")); ?>'  href='<?php echo e(route("admin.affiliate.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Affiliate Reports')); ?>

                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.transaction.report.*")); ?>'  href='<?php echo e(route("admin.transaction.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Transaction Reports')); ?>

                    </p>
                  </a>
                </li>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.kyc.report.*")); ?>'  href='<?php echo e(route("admin.kyc.report.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('KYC Reports')); ?>


                        <?php if($pending_kycs > 0 ): ?>
                            <span  data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('Pending KYC logs')); ?>" class="i-badge danger"><?php echo e($pending_kycs); ?></span>
                        <?php endif; ?>
                    </p>
                  </a>
                </li>

                <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.webhook.report.*")); ?>'  href='<?php echo e(route("admin.webhook.report.list")); ?>'>
                      <span></span>
                      <p>
                        <?php echo e(translate('Webhook Reports')); ?>

                      </p>
                    </a>
                </li>

              </ul>
            </div>
          </li>
        <?php endif; ?>




        <?php if(check_permission('view_ai_template')): ?>
            <li class="sidebar-menu-title">
                <?php echo e(translate('AI Content')); ?>

            </li>

            <li class="sidebar-menu-item">
              <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#aiTemplate" role="button"
                aria-expanded="false" aria-controls="aiTemplate">
              <span><i class="las la-sliders-h"></i></span>
                <p>
                  <?php echo e(translate('AI Templates')); ?>

                </p>
                <small >
                    <i class="las la-angle-down"></i>
                </small>
              </a>
              <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.ai.template.*' , 'admin.category.*'],'drop_down')); ?> " id="aiTemplate">
                <ul class="sub-menu">

                  <li class="sub-menu-item">
                      <a  href='<?php echo e(route("admin.category.list")); ?>' class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.category.*"])); ?>'>
                        <span></span>
                        <p>
                          <?php echo e(translate("Categories")); ?>

                        </p>
                      </a>
                  </li>

                  <li class="sub-menu-item">
                      <a  href='<?php echo e(route("admin.ai.template.list")); ?>' class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.ai.template.list","admin.ai.template.edit","admin.ai.template.create","admin.ai.template.content"])); ?> '>
                        <span></span>
                        <p>
                          <?php echo e(translate("Templates")); ?>

                        </p>
                      </a>
                  </li>
                  <li class="sub-menu-item">
                    <a  href='<?php echo e(route("admin.ai.template.default")); ?>'  class='sidebar-menu-link <?php echo e(sidebar_awake("admin.ai.template.default")); ?>'>
                        <span></span>
                        <p>
                          <?php echo e(translate("Default Templates")); ?>

                        </p>
                    </a>
                  </li>

                </ul>
              </div>
            </li>
        <?php endif; ?>

        <?php if(check_permission('view_content')): ?>
            <li class="sidebar-menu-item">
                <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.content.*")); ?>'  href='<?php echo e(route("admin.content.list")); ?>'>
                  <span><i class="las la-clipboard-list"></i></span>
                  <p>
                    <?php echo e(translate('Contents')); ?>

                  </p>
                </a>
            </li>
        <?php endif; ?>



        <li class="sidebar-menu-title">
            <?php echo e(translate('Frontend Configuration')); ?>

        </li>
        <li class="sidebar-menu-item">
          <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#frontend" role="button"
            aria-expanded="false" aria-controls="frontend">
            <span><i class="las la-puzzle-piece"></i></span>
            <p>
                <?php echo e(translate('Sections')); ?>

            </p>
            <small >
              <i class="las la-angle-down"></i>
            </small>
          </a>

          <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.appearance.*','admin.menu.*','admin.page.*'],'drop_down')); ?> " id="frontend">
            <ul class="sub-menu">
              <?php if(check_permission('view_frontend')): ?>
                <?php
                    $appearanceSegment = collect(request()->segments())->last();
                ?>
                <?php $__currentLoopData = get_appearance(true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $appearance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(isset($appearance['builder']) && $appearance['builder']): ?>

                      <li class="sub-menu-item">
                          <a class="sidebar-menu-link <?php if($key == $appearanceSegment ||  (@$appearance['child_section']  && @$appearance['child_section'] == request()->route('key')) ): ?> active <?php endif; ?>"  href='<?php echo e(route("admin.appearance.list",$key)); ?>'>
                            <span></span>
                            <p>
                              <?php echo e(translate(k2t($appearance['name']))); ?>

                            </p>
                          </a>
                      </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>

              <?php if(check_permission('view_page')): ?>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.page.*")); ?>'  href='<?php echo e(route("admin.page.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Pages')); ?>

                    </p>
                  </a>
                </li>
              <?php endif; ?>

              <?php if(check_permission('view_menu')): ?>
                <li class="sub-menu-item">
                  <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.menu.*")); ?>' href='<?php echo e(route("admin.menu.list")); ?>'>
                    <span></span>
                    <p>
                      <?php echo e(translate('Menu')); ?>

                    </p>
                  </a>
                </li>
              <?php endif; ?>
            </ul>
          </div>
        </li>

        <?php if(check_permission('view_blog') || check_permission('view_category')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#blog" role="button"
              aria-expanded="false" aria-controls="blog">
              <span><i class="las la-newspaper"> </i> </span>
              <p>
                <?php echo e(translate('Blogs')); ?>

              </p>
              <small >
                <i class="las la-angle-down"></i>
              </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.blog.*'],'drop_down')); ?> " id="blog">
              <ul class="sub-menu">


                <?php if(check_permission('view_blog')): ?>

                  <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.blog.list","admin.blog.edit"])); ?>' href='<?php echo e(route("admin.blog.list")); ?>'>
                        <span></span>
                          <p>
                            <?php echo e(translate('Blogs')); ?>

                          </p>
                        </a>
                  </li>
                  <li class="sub-menu-item">
                      <a class="sidebar-menu-link  <?php echo e(sidebar_awake('admin.blog.create')); ?>" href="<?php echo e(route('admin.blog.create')); ?>">
                        <span></span>
                        <p>
                          <?php echo e(translate('Add New')); ?>

                        </p>
                      </a>
                  </li>
                <?php endif; ?>
              </ul>
            </div>
          </li>
        <?php endif; ?>


        <?php if(check_permission('view_frontend')): ?>

            <li class="sidebar-menu-item">
              <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#marketing" role="button"
                aria-expanded="false" aria-controls="marketing">
                <span><i class="las la-ad"></i> </span>
                  <p>
                    <?php echo e(translate('Manage Promotions')); ?>

                  </p>
                  <small >
                    <i class="las la-angle-down"></i>
                  </small>
              </a>
              <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.contact.*','admin.subscriber.*','admin.ad.*'],'drop_down')); ?> " id="marketing">
                <ul class="sub-menu">
                    <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.contact.*")); ?>'  href='<?php echo e(route("admin.contact.list")); ?>'>
                          <span></span>
                            <p>
                              <?php echo e(translate('Contacts')); ?>

                            </p>
                        </a>
                    </li>
                    <li class="sub-menu-item">
                      <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.subscriber.*")); ?>'  href='<?php echo e(route("admin.subscriber.list")); ?>'>
                        <span></span>
                          <p>
                            <?php echo e(translate('Subscribers')); ?>

                          </p>
                      </a>
                    </li>
                </ul>
              </div>
            </li>
        <?php endif; ?>


       <?php if(check_permission('view_settings') || check_permission('view_language')): ?>
          <li class="sidebar-menu-title">
              <?php echo e(translate('System Configuration')); ?>

          </li>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link" data-bs-toggle="collapse" href="#setting" role="button"
              aria-expanded="false" aria-controls="setting">
              <span><i class="las la-cog"></i></span>
                <p>
                  <?php echo e(translate('System Settings')); ?>


                </p>
                <small >
                  <i class="las la-angle-down"></i>
                </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.setting.*','admin.language.*'],'drop_down')); ?> " id="setting">
              <ul class="sub-menu">

                <?php if(check_permission('view_settings')): ?>
                    <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.list")); ?>'  href='<?php echo e(route("admin.setting.list")); ?>'>
                        <span></span>
                        <p>
                            <?php echo e(translate('App Settings')); ?>

                        </p>
                        </a>
                    </li>
                    <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.configuration.*")); ?>'  href='<?php echo e(route("admin.setting.configuration.index")); ?>'>
                        <span></span>
                        <p>
                            <?php echo e(translate('System Preferences')); ?>

                        </p>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if(check_permission('view_language')): ?>
                  <li class="sub-menu-item">
                      <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.language.*")); ?>'  href='<?php echo e(route("admin.language.list")); ?>'>
                        <span></span>
                        <p>
                          <?php echo e(translate('Languages')); ?>

                        </p>
                      </a>
                  </li>
                <?php endif; ?>

                <?php if(check_permission('view_settings')): ?>
                    <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.openAi")); ?>'  href='<?php echo e(route("admin.setting.openAi")); ?>'>
                        <span></span>
                            <p>
                            <?php echo e(translate('AI Configuration')); ?>

                            </p>
                        </a>
                    </li>
                    <li class="sub-menu-item">
                        <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.webhook")); ?>'  href='<?php echo e(route("admin.setting.webhook")); ?>'>
                        <span></span>
                            <p>
                            <?php echo e(translate('Webhook Configuration')); ?>

                            </p>
                        </a>
                    </li>
                    <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.affiliate")); ?>'  href='<?php echo e(route("admin.setting.affiliate")); ?>'>
                        <span></span>
                        <p>
                            <?php echo e(translate('Affiliate Configuration')); ?>

                        </p>
                    </a>
                    </li>
                    <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.kyc")); ?>'  href='<?php echo e(route("admin.setting.kyc")); ?>'>
                        <span></span>
                        <p>
                            <?php echo e(translate('KYC Configuration')); ?>

                        </p>
                    </a>
                    </li>
                <?php endif; ?>
              </ul>
            </div>
          </li>
       <?php endif; ?>

       <?php if(check_permission('view_Security')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link" data-bs-toggle="collapse" href="#securitySetting" role="button"
              aria-expanded="false" aria-controls="securitySetting">
              <span><i class="las la-shield-alt"></i></span>
                <p>
                  <?php echo e(translate('Security Settings')); ?>


                </p>
                <small >
                  <i class="las la-angle-down"></i>
                </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.security.*'],'drop_down')); ?> " id="securitySetting">
              <ul class="sub-menu">
                  <li class="sub-menu-item">
                      <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.security.country.list")); ?>'  href='<?php echo e(route("admin.security.country.list")); ?>'>
                        <span></span>
                        <p>
                          <?php echo e(translate('Countries')); ?>

                        </p>
                      </a>
                  </li>
                  <li class="sub-menu-item">
                      <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.security.ip.list")); ?>'  href='<?php echo e(route("admin.security.ip.list")); ?>'>
                        <span></span>
                        <p>
                           <?php echo e(translate('IP List')); ?>

                        </p>
                      </a>
                  </li>
                  <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.security.dos")); ?>'  href='<?php echo e(route("admin.security.dos")); ?>'>
                      <span></span>
                      <p>
                         <?php echo e(translate('Dos Security')); ?>

                      </p>
                    </a>
                </li>
              </ul>
            </div>
          </li>
       <?php endif; ?>

       <?php if(check_permission('view_currency')): ?>
          <li class="sidebar-menu-item">
              <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.currency.list")); ?>' data-anim="ripple" href="<?php echo e(route('admin.currency.list')); ?>" aria-expanded="false">
                  <span><i class="las la-euro-sign"></i></span>
                  <p><?php echo e(translate('Currencies')); ?></p>
              </a>
          </li>
       <?php endif; ?>

       <?php if(check_permission('view_method')): ?>
        <li class="sidebar-menu-item">
          <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#payment" role="button"
            aria-expanded="false" aria-controls="payment">
            <span><i class="las la-money-bill"></i></span>
              <p>
                <?php echo e(translate('Payment Gateway')); ?>

              </p>
              <small >
                  <i class="las la-angle-down"></i>
              </small>
          </a>
          <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.paymentMethod.*'],'drop_down')); ?> " id="payment">
            <ul class="sub-menu">
                <?php $__currentLoopData = ['automatic','manual']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li class="sub-menu-item">
                      <a class="sidebar-menu-link <?php if(request()->route('type') == $type ): ?>  active <?php endif; ?>"  href='<?php echo e(route("admin.paymentMethod.list",$type)); ?>'>
                        <span></span>
                        <p>
                          <?php echo e(ucfirst($type).translate(' Method')); ?>

                        </p>
                      </a>
                  </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        </li>
       <?php endif; ?>

      <?php if(check_permission('view_withdraw')): ?>
        <li class="sidebar-menu-item">
            <a class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.withdraw.list","admin.withdraw.edit","admin.withdraw.create"])); ?>' data-anim="ripple" href="<?php echo e(route('admin.withdraw.list')); ?>" aria-expanded="false">
                <span><i class="las la-dolly-flatbed"></i></span>
                <p><?php echo e(translate('Withdraw Method')); ?></p>
            </a>
        </li>
      <?php endif; ?>

      <?php if(check_permission('view_template')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#notificationTemplates" role="button"
              aria-expanded="false" aria-controls="notificationTemplates">
              <span><i class="las la-bell"></i></span>
                <p>
                  <?php echo e(translate('Notification Templates')); ?>

                </p>
                <small >
                  <i class="las la-angle-down"></i>
                </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.template.*'],'drop_down')); ?> " id="notificationTemplates">
              <ul class="sub-menu">
                <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake(["admin.template.list","admin.template.edit"])); ?>' href="<?php echo e(route('admin.template.list')); ?>">
                      <span></span>
                        <p>
                            <?php echo e(translate('Notification Template')); ?>

                        </p>
                    </a>
                </li>
                <li class="sub-menu-item">
                    <a class="sidebar-menu-link <?php echo e(sidebar_awake('admin.template.global')); ?>" href="<?php echo e(route('admin.template.global')); ?>">
                      <span></span>
                        <p>
                            <?php echo e(translate('Global Template')); ?>

                        </p>
                    </a>
                </li>
              </ul>
            </div>
          </li>
      <?php endif; ?>


      <?php if(check_permission('view_gateway')): ?>
          <li class="sidebar-menu-item">
            <a  class="sidebar-menu-link " data-bs-toggle="collapse" href="#notificationGateway" role="button"
              aria-expanded="false" aria-controls="notificationGateway">
              <span><i class="las la-cogs"></i></span>
                <p>
                  <?php echo e(translate('Notification Gateway')); ?>

                </p>
                <small >
                  <i class="las la-angle-down"></i>
                </small>
            </a>
            <div class="side-menu-dropdown collapse <?php echo e(sidebar_awake(['admin.mailGateway.*','admin.smsGateway.*'],'drop_down')); ?> " id="notificationGateway">
              <ul class="sub-menu">
                <li class="sub-menu-item">
                    <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.mailGateway.*")); ?>' href='<?php echo e(route("admin.mailGateway.list")); ?>'>
                      <span></span>
                        <p>
                          <?php echo e(translate('Mail Gateway')); ?>

                        </p>
                    </a>
                </li>
                <li class="sub-menu-item">
                    <a class="sidebar-menu-link <?php echo e(sidebar_awake('admin.smsGateway.*')); ?>" href="<?php echo e(route('admin.smsGateway.list')); ?>">
                      <span></span>
                        <p>
                          <?php echo e(translate('SMS Gateway')); ?>

                        </p>
                    </a>
                </li>
              </ul>
            </div>
          </li>
      <?php endif; ?>


      <?php if(check_permission('view_settings')): ?>
        <li class="sidebar-menu-title">
            <?php echo e(translate('Server Info')); ?>

        </li>
        <li class="sidebar-menu-item">
            <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.setting.server.info")); ?>'  href='<?php echo e(route("admin.setting.server.info")); ?>'>
              <span><i class="las la-server"></i></span>
              <p>
                <?php echo e(translate('Server Info')); ?>

              </p>
            </a>
        </li>


        <li class="sidebar-menu-item">
          <a class='sidebar-menu-link <?php echo e(sidebar_awake("admin.system.update.init")); ?>'  href='<?php echo e(route("admin.system.update.init")); ?>'>
            <span><i class="las la-ellipsis-h"></i></span>
            <p>
              <?php echo e(translate('System Update')); ?>

              <span data-bs-toggle="tooltip" data-bs-placement="top"    data-bs-title="<?php echo e(translate('APP Version')); ?>"  class="i-badge danger">
                   <?php echo e(translate('V')); ?><?php echo e(site_settings("app_version",1.1)); ?>

              </span>
            </p>
          </a>
      </li>


      <?php endif; ?>

    </ul>
  </div>
</div>
<?php /**PATH D:\laragon\www\beepost\kode\resources\views/admin/partials/sidebar.blade.php ENDPATH**/ ?>