"use strict";
(function ($) {
    // ==========================================
    // Start Document Ready function
    // ==========================================
    $(document).ready(function () {
        // ========================= Header Sticky Js Start ==============
        $(window).on("scroll", function () {
            if ($(window).scrollTop() >= 300) {
                $(".header").addClass("fixed-header");
            } else {
                $(".header").removeClass("fixed-header");
            }
        });
        // ========================= Header Sticky Js End===================

        // //============================ Scroll To Top Icon Js Start =========
        var btn = $(".scroll-top");

        $(window).scroll(function () {
            if ($(window).scrollTop() > 300) {
                btn.addClass("show");
            } else {
                btn.removeClass("show");
            }
        });

        btn.on("click", function (e) {
            e.preventDefault();
            $("html, body").animate({ scrollTop: 0 }, "300");
        });

        // ========================== Add Attribute For Bg Image Js Start =====================
        $(".bg-img").css("background-image", function () {
            var bg = "url(" + $(this).data("background-image") + ")";
            return bg;
        });

        $(".show-filter").on("click", function () {
            $(this).siblings(".responsive-filter-card").toggleClass("d-block");
        });
        // ========================== Add Attribute For Bg Image Js End =====================

        // ========================== add active class to ul>li top Active current page Js Start =====================
        function dynamicActiveMenuClass(selector) {
            let fileName = window.location.pathname.split("/").reverse()[0];
            selector.find("li").each(function () {
                let anchor = $(this).find("a");
                if ($(anchor).attr("href") == fileName) {
                    $(this).addClass("active");
                }
            });
            // if any li has active element add class
            selector.children("li").each(function () {
                if ($(this).find(".active").length) {
                    $(this).addClass("active");
                }
            });
            // if no file name return
            if ("" == fileName) {
                selector.find("li").eq(0).addClass("active");
            }
        }
        if ($("ul.sidebar-menu-list").length) {
            dynamicActiveMenuClass($("ul.sidebar-menu-list"));
        }
        // ========================== add active class to ul>li top Active current page Js End =====================

        // ================== Password Show Hide Js Start ==========

        $(".toggle-password").on("click", function () {
            $(this).toggleClass("fa-eye");
            var elementClass = $(this).data("password-element");
            var $input = $(`.${elementClass}`);
            if ($input.attr("type") == "password") {
                $input.attr("type", "text");
            } else {
                $input.attr("type", "password");
            }
        });

        // =============== Password Show Hide Js End =================

        // ========================= Slick Slider Js Start ==============
        if ($(".testimonial-card--list").length) {
            $(".testimonial-card--list").slick({
                slidesToShow: 2,
                slidesToScroll: 1,
                autoplay: false,
                autoplaySpeed: 2000,
                speed: 1500,
                dots: true,
                pauseOnHover: true,
                arrows: false,
                responsive: [
                    {
                        breakpoint: 1199,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                            dots: true,
                        },
                    },
                    {
                        breakpoint: 991,
                        settings: {
                            arrows: false,
                            slidesToShow: 2,
                        },
                    },
                    {
                        breakpoint: 575,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                        },
                    },
                ],
            });
        }
        // ========================= Slick Slider Js End ===================




        // ========================= Banner Slider Js Start ==============
        if ($(".overlay-slider").length) {
            $(".overlay-slider").slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                autoplay: true,
                autoplaySpeed: 3000,
                speed: 1500,
                fade: true,
                arrows: false,
                asNavFor: ".banner-content__list",
            });
        }

        if ($(".banner-content__list").length) {
            $(".banner-content__list").slick({
                slidesToShow: 1,
                slidesToScroll: 3,
                arrows: false,
                draggable: false,
                fade: true,
                asNavFor: ".overlay-slider",
            });
        }
        // ========================= Banner Slider Js End ===================

        // ========================= Campaign Tab Style Js Start ===================
        (function () {
            $(".campaign-details__body .nav-link").on("click", updateBar);
            function updateBar() {
                var activeNavItem = $(".campaign-details__body .nav-link.active");
                if (activeNavItem.length > 0) {
                    var width = activeNavItem.outerWidth();
                    var position = activeNavItem.position().left;
                    $(".active-effect").css({
                        width: width + "px",
                        left: position + "px",
                    });
                }
            }
            updateBar();
        })();
        // ========================= Campaign Tab Style Js End ===================

        // ========================= Flatpickr Js Start ===================
        
        if ($("#datepicker").length > 0) {
            $("#datepicker").flatpickr();
        }
        // ========================= Flatpickr Js End ===================

        // ========================= Client Slider Js Start ===============
        function gallerySlider() {
            if ($(".gallery-item").length) {
                $(".gallery-item").slick({
                    slidesToShow: 5,
                    slidesToScroll: 1,
                    autoplay: false,
                    infinite: false,
                    dots: false,
                    arrows: true,
                    prevArrow:
                        '<button type="button" class="slick-prev"><i class="fa-solid fa-angle-left"></i></button>',
                    nextArrow:
                        '<button type="button" class="slick-next"><i class="fa-solid fa-angle-right"></i></button>',
                    responsive: [
                        {
                            breakpoint: 991,
                            settings: {
                                slidesToShow: 5,
                            },
                        },
                        {
                            breakpoint: 767,
                            settings: {
                                slidesToShow: 2,
                            },
                        },
                        {
                            breakpoint: 400,
                            settings: {
                                slidesToShow: 1,
                            },
                        },
                    ],
                });
            }
        }
        $("#pills-update-tab").on("click", gallerySlider);
        // ========================= Client Slider Js End ===================

        // ================== Sidebar Menu Js Start ===============
        // Sidebar Dropdown Menu Start
        $(".sidebar-submenu").each(function () {
            if (!$(this).parent().hasClass("active")) {
                $(".sidebar-submenu").slideUp(0);
            }
        })

        $(".has-dropdown").click(function () {
            $(".sidebar-submenu").slideUp(200);
            if ($(this).parent().hasClass("active")) {
                $(this).parent().removeClass("active");
            } else {
                $(this).next(".sidebar-submenu").slideDown(200);
                $(this).parent().addClass("active");
            }
        });
        // Sidebar Dropdown Menu End
        // Sidebar Icon & Overlay js
        $(".navigation-bar").on("click", function () {
            $(".sidebar-menu").addClass("show-sidebar");
            $(".sidebar-overlay").addClass("show");
        });
        $(".sidebar-menu__close, .sidebar-overlay").on("click", function () {
            $(".sidebar-menu").removeClass("show-sidebar");
            $(".sidebar-overlay").removeClass("show");
        });
        // Sidebar Icon & Overlay js
        // ===================== Sidebar Menu Js End =================

        // ==================== Dashboard User Profile Dropdown Start ==================
        $(".user-info__button").on("click", function () {
            $(".user-info-dropdown").toggleClass("show");
        });
        $(".user-info__button").attr("tabindex", -1).focus();

        $(".user-info__button").on("focusout", function () {
            $(".user-info-dropdown").removeClass("show");
        });
        // ==================== Dashboard User Profile Dropdown End ==================

        $(".thumb-upload").on("dragover", function (e) {
            e.preventDefault();
            $(this).addClass("dragover");
        });

        $(".thumb-upload").on("dragleave", function (e) {
            e.preventDefault();
            $(this).removeClass("dragover");
        });

        $(".thumb-upload").on("drop", function (e) {
            e.preventDefault();
            $(this).removeClass("dragover");

            const file = e.originalEvent.dataTransfer.files[0];
            updateThumbnail($(this).find(".preview"), file);
        });

        $(".thumb-upload input").on("change", function (e) {
            const file = e.target.files[0];
            updateThumbnail($(this).siblings(".preview"), file);
        });

        function updateThumbnail(preview, file) {
            if (file.type.startsWith("image/")) {
                const reader = new FileReader();
                reader.readAsDataURL(file);
                reader.onload = (e) => {
                    preview.css("background-image", `url('${e.target.result}')`);
                };
            }
        }

        // ========================= Play popup Video Js Start ==========
        if ($(".popup-video").length) {
            $(".popup-video").magnificPopup({
                type: "iframe",
            });
        }
        if ($(".popup-img").length) {
            $(".popup-img").magnificPopup({
                type: "image",
            });
        }

        // ========================= Play popup Video Js End ==========

        // ========================= Odometer Counter Up Js End ==========
        $(".counterup-item").each(function () {
            $(this).isInViewport(function (status) {
                if (status === "entered") {
                    $(".odometer").each(function () {
                        $(this).html($(this).data("odometer-final"));
                    });
                }
            });
        });
        // ========================= Odometer Up Counter Js End =====================
        $(".select2-country").select2();
    });

    // ==========================================
    // End Document Ready function
    // ==========================================

    // ========================= Preloader Js Start =====================

    $(window).on("load", function () {
        $(".preloader").fadeOut();
    });

    // ========================= Preloader Js End=====================

    $(".copy").on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        var copyText = document.getElementById($(this).data("id"));
        copyText.select();
        copyText.setSelectionRange(0, 99999);
        document.execCommand("copy");
        $(this).find(".copyText").text("Copied");
        setTimeout(() => {
            $(this).find(".copyText").text("Copy");
        }, 2000);
    });

    let fromHeight = $('.donation-cta-section').height();
    document.documentElement.style.setProperty('--form-h', `${fromHeight}px`);
    

})(jQuery);




