<?php
if (!function_exists("languages")) {
    function languages(){
        $languages = [
            "ar-AE" => "Arabic",
            "az-AZ" => "Azerbaijani (Azerbaijan)",
            "cmn-CN" => "Chinese (Mandarin)",
            "hr-HR" => "Croatian (Croatia)",
            "cs-CZ" => "Czech (Czech Republic)",
            "da-DK" => "Danish (Denmark)",
            "nl-NL" => "Dutch (Netherlands)",
            "en-US" => "English (USA)",
            "en-GB" => "English (UK)",
            "et-EE" => "Estonian (Estonia)",
            "fi-FI" => "Finnish (Finland)",
            "fr-FR" => "French (France)",
            "de-DE" => "German (Germany)",
            "el-GR" => "Greek (Greece)",
            "he-IL" => "Hebrew (Israel)",
            "hi-IN" => "Hindi (India)",
            "hu-HU" => "Hungarian (Hungary)",
            "is-IS" => "Icelandic (Iceland)",
            "id-ID" => "Indonesian (Indonesia)",
            "it-IT" => "Italian (Italy)",
            "ja-JP" => "Japanese (Japan)",
            "kk-KZ" => "Kazakh (Kazakhistan)",
            "ko-KR" => "Korean (South Korea)",
            "lt-LT" => "Lithuanian (Lithuania)",
            "ms-MY" => "Malay (Malaysia)",
            "mk-MK" => "Macedonian (Macedonia)",
            "nb-NO" => "Norwegian (Norway)",
            "pl-PL" => "Polish (Poland)",
            "pt-BR" => "Portuguese (Brazil)",
            "pt-PT" => "Portuguese (Portugal)",
            "ro-RO" => "Romanian (Romania)",
            "ru-RU" => "Russian (Russia)",
            "sl-SI" => "Slovenian (Slovenia)",
            "sk-SK" => "Slovakian (Slovakia)",
            "es-ES" => "Spanish (Spain)",
            "es-MX" => "Spanish (Mexico)",
            "sw-KE" => "Swahili (Kenya)",
            "sv-SE" => "Swedish (Sweden)",
            "tr-TR" => "Turkish (Turkey)",
            "th-TH" => "Thai (Thailand)",
            "vi-VN" => "Vietnamese (Vietnam)",
        ];

        return $languages;
    }
}

if( !function_exists('get_language_code') ){
    function get_language_codes(){
        $codes = [
            "af" => "Afrikaans",
            "ak" => "Akan",
            "sq" => "Albanian",
            "am" => "Amharic",
            "ar" => "Arabic",
            "hy" => "Armenian",
            "rup" => "Aromanian",
            "as" => "Assamese",
            "az" => "Azerbaijani",
            "az-tr" => "Azerbaijani (Turkey)",
            "ba" => "Bashkir",
            "eu" => "Basque",
            "bel" => "Belarusian",
            "bn" => "Bengali",
            "bs" => "Bosnian",
            "bg" => "Bulgarian",
            "mya" => "Burmese",
            "ca" => "Catalan",
            "bal" => "Catalan (Balear)",
            "zh-cn" => "Chinese (China)",
            "zh-hk" => "Chinese (Hong Kong)",
            "zh-tw" => "Chinese (Taiwan)",
            "co" => "Corsican",
            "hr" => "Croatian",
            "cs" => "Czech",
            "da" => "Danish",
            "dv" => "Dhivehi",
            "nl" => "Dutch",
            "nl-be" => "Dutch (Belgium)",
            "en" => "English",
            "en-au" => "English (Australia)",
            "en-ca" => "English (Canada)",
            "en-gb" => "English (UK)",
            "eo" => "Esperanto",
            "et" => "Estonian",
            "fo" => "Faroese",
            "fi" => "Finnish",
            "fr-be" => "French (Belgium)",
            "fr" => "French (France)",
            "fy" => "Frisian",
            "fuc" => "Fulah",
            "gl" => "Galician",
            "ka" => "Georgian",
            "de" => "German",
            "de-ch" => "German (Switzerland)",
            "el" => "Greek",
            "gn" => "Guaraní",
            "gu" => "Gujarati",
            "haw" => "Hawaiian",
            "haz" => "Hazaragi",
            "he" => "Hebrew",
            "hi" => "Hindi",
            "hu" => "Hungarian",
            "is" => "Icelandic",
            "ido" => "Ido",
            "id" => "Indonesian",
            "ga" => "Irish",
            "it" => "Italian",
            "ja" => "Japanese",
            "jv" => "Javanese",
            "kn" => "Kannada",
            "kk" => "Kazakh",
            "km" => "Khmer",
            "kin" => "Kinyarwanda",
            "ky" => "Kirghiz",
            "ko" => "Korean",
            "ckb" => "Kurdish (Sorani)",
            "lo" => "Lao",
            "lv" => "Latvian",
            "li" => "Limburgish",
            "lin" => "Lingala",
            "lt" => "Lithuanian",
            "lb" => "Luxembourgish",
            "mk" => "Macedonian",
            "mg" => "Malagasy",
            "ms" => "Malay",
            "ml" => "Malayalam",
            "mr" => "Marathi",
            "xmf" => "Mingrelian",
            "mn" => "Mongolian",
            "me" => "Montenegrin",
            "ne" => "Nepali",
            "nb" => "Norwegian (Bokmål)",
            "nn" => "Norwegian (Nynorsk)",
            "ory" => "Oriya",
            "os" => "Ossetic",
            "ps" => "Pashto",
            "fa" => "Persian",
            "fa-af" => "Persian (Afghanistan)",
            "pl" => "Polish",
            "pt-br" => "Portuguese (Brazil)",
            "pt" => "Portuguese (Portugal)",
            "pa" => "Punjabi",
            "rhg" => "Rohingya",
            "ro" => "Romanian",
            "ru" => "Russian",
            "ru-ua" => "Russian (Ukraine)",
            "rue" => "Rusyn",
            "sah" => "Sakha",
            "sa-in" => "Sanskrit",
            "srd" => "Sardinian",
            "gd" => "Scottish Gaelic",
            "sr" => "Serbian",
            "sd" => "Sindhi",
            "si" => "Sinhala",
            "sk" => "Slovak",
            "sl" => "Slovenian",
            "so" => "Somali",
            "azb" => "South Azerbaijani",
            "es-ar" => "Spanish (Argentina)",
            "es-cl" => "Spanish (Chile)",
            "es-co" => "Spanish (Colombia)",
            "es-mx" => "Spanish (Mexico)",
            "es-pe" => "Spanish (Peru)",
            "es-pr" => "Spanish (Puerto Rico)",
            "es" => "Spanish (Spain)",
            "es-ve" => "Spanish (Venezuela)",
            "su" => "Sundanese",
            "sw" => "Swahili",
            "sv" => "Swedish",
            "gsw" => "Swiss German",
            "tl" => "Tagalog",
            "tg" => "Tajik",
            "tzm" => "Tamazight (Central Atlas)",
            "ta" => "Tamil",
            "ta-lk" => "Tamil (Sri Lanka)",
            "tt" => "Tatar",
            "te" => "Telugu",
            "th" => "Thai",
            "bo" => "Tibetan",
            "tir" => "Tigrinya",
            "tr" => "Turkish",
            "tuk" => "Turkmen",
            "ug" => "Uighur",
            "uk" => "Ukrainian",
            "ur" => "Urdu",
            "uz" => "Uzbek",
            "vi" => "Vietnamese",
            "wa" => "Walloon",
            "cy" => "Welsh",
            "yor" => "Yoruba"
        ];

        return $codes;
    }
}

if(!function_exists('list_countries')){
    function list_countries($key = ""){
        $countries = array(
              "AF" => "Afghanistan",
              "AX" => "Åland Islands",
              "AL" => "Albania",
              "DZ" => "Algeria",
              "AS" => "American Samoa",
              "AD" => "Andorra",
              "AO" => "Angola",
              "AI" => "Anguilla",
              "AQ" => "Antarctica",
              "AG" => "Antigua and Barbuda",
              "AR" => "Argentina",
              "AM" => "Armenia",
              "AW" => "Aruba",
              "AU" => "Australia",
              "AT" => "Austria",
              "AZ" => "Azerbaijan",
              "BS" => "Bahamas",
              "BH" => "Bahrain",
              "BD" => "Bangladesh",
              "BB" => "Barbados",
              "BY" => "Belarus",
              "BE" => "Belgium",
              "BZ" => "Belize",
              "BJ" => "Benin",
              "BM" => "Bermuda",
              "BT" => "Bhutan",
              "BO" => "Bolivia, Plurinational State of",
              "BQ" => "Bonaire, Sint Eustatius and Saba",
              "BA" => "Bosnia and Herzegovina",
              "BW" => "Botswana",
              "BV" => "Bouvet Island",
              "BR" => "Brazil",
              "IO" => "British Indian Ocean Territory",
              "BN" => "Brunei Darussalam",
              "BG" => "Bulgaria",
              "BF" => "Burkina Faso",
              "BI" => "Burundi",
              "KH" => "Cambodia",
              "CM" => "Cameroon",
              "CA" => "Canada",
              "CV" => "Cape Verde",
              "KY" => "Cayman Islands",
              "CF" => "Central African Republic",
              "TD" => "Chad",
              "CL" => "Chile",
              "CN" => "China",
              "CX" => "Christmas Island",
              "CC" => "Cocos (Keeling) Islands",
              "CO" => "Colombia",
              "KM" => "Comoros",
              "CG" => "Congo",
              "CD" => "Congo, the Democratic Republic of the",
              "CK" => "Cook Islands",
              "CR" => "Costa Rica",
              "CI" => "Côte d'Ivoire",
              "HR" => "Croatia",
              "CU" => "Cuba",
              "CW" => "Curaçao",
              "CY" => "Cyprus",
              "CZ" => "Czech Republic",
              "DK" => "Denmark",
              "DJ" => "Djibouti",
              "DM" => "Dominica",
              "DO" => "Dominican Republic",
              "EC" => "Ecuador",
              "EG" => "Egypt",
              "SV" => "El Salvador",
              "GQ" => "Equatorial Guinea",
              "ER" => "Eritrea",
              "EE" => "Estonia",
              "ET" => "Ethiopia",
              "FK" => "Falkland Islands (Malvinas)",
              "FO" => "Faroe Islands",
              "FJ" => "Fiji",
              "FI" => "Finland",
              "FR" => "France",
              "GF" => "French Guiana",
              "PF" => "French Polynesia",
              "TF" => "French Southern Territories",
              "GA" => "Gabon",
              "GM" => "Gambia",
              "GE" => "Georgia",
              "DE" => "Germany",
              "GH" => "Ghana",
              "GI" => "Gibraltar",
              "GR" => "Greece",
              "GL" => "Greenland",
              "GD" => "Grenada",
              "GP" => "Guadeloupe",
              "GU" => "Guam",
              "GT" => "Guatemala",
              "GG" => "Guernsey",
              "GN" => "Guinea",
              "GW" => "Guinea-Bissau",
              "GY" => "Guyana",
              "HT" => "Haiti",
              "HM" => "Heard Island and McDonald Islands",
              "VA" => "Holy See (Vatican City State)",
              "HN" => "Honduras",
              "HK" => "Hong Kong",
              "HU" => "Hungary",
              "IS" => "Iceland",
              "IN" => "India",
              "ID" => "Indonesia",
              "IR" => "Iran, Islamic Republic of",
              "IQ" => "Iraq",
              "IE" => "Ireland",
              "IM" => "Isle of Man",
              "IL" => "Israel",
              "IT" => "Italy",
              "JM" => "Jamaica",
              "JP" => "Japan",
              "JE" => "Jersey",
              "JO" => "Jordan",
              "KZ" => "Kazakhstan",
              "KE" => "Kenya",
              "KI" => "Kiribati",
              "KP" => "Korea, Democratic People's Republic of",
              "KR" => "Korea, Republic of",
              "KW" => "Kuwait",
              "KG" => "Kyrgyzstan",
              "LA" => "Lao People's Democratic Republic",
              "LV" => "Latvia",
              "LB" => "Lebanon",
              "LS" => "Lesotho",
              "LR" => "Liberia",
              "LY" => "Libya",
              "LI" => "Liechtenstein",
              "LT" => "Lithuania",
              "LU" => "Luxembourg",
              "MO" => "Macao",
              "MK" => "Macedonia, the former Yugoslav Republic of",
              "MG" => "Madagascar",
              "MW" => "Malawi",
              "MY" => "Malaysia",
              "MV" => "Maldives",
              "ML" => "Mali",
              "MT" => "Malta",
              "MH" => "Marshall Islands",
              "MQ" => "Martinique",
              "MR" => "Mauritania",
              "MU" => "Mauritius",
              "YT" => "Mayotte",
              "MX" => "Mexico",
              "FM" => "Micronesia, Federated States of",
              "MD" => "Moldova, Republic of",
              "MC" => "Monaco",
              "MN" => "Mongolia",
              "ME" => "Montenegro",
              "MS" => "Montserrat",
              "MA" => "Morocco",
              "MZ" => "Mozambique",
              "MM" => "Myanmar",
              "NA" => "Namibia",
              "NR" => "Nauru",
              "NP" => "Nepal",
              "NL" => "Netherlands",
              "NC" => "New Caledonia",
              "NZ" => "New Zealand",
              "NI" => "Nicaragua",
              "NE" => "Niger",
              "NG" => "Nigeria",
              "NU" => "Niue",
              "NF" => "Norfolk Island",
              "MP" => "Northern Mariana Islands",
              "NO" => "Norway",
              "OM" => "Oman",
              "PK" => "Pakistan",
              "PW" => "Palau",
              "PS" => "Palestinian Territory, Occupied",
              "PA" => "Panama",
              "PG" => "Papua New Guinea",
              "PY" => "Paraguay",
              "PE" => "Peru",
              "PH" => "Philippines",
              "PN" => "Pitcairn",
              "PL" => "Poland",
              "PT" => "Portugal",
              "PR" => "Puerto Rico",
              "QA" => "Qatar",
              "RE" => "Réunion",
              "RO" => "Romania",
              "RU" => "Russian Federation",
              "RW" => "Rwanda",
              "BL" => "Saint Barthélemy",
              "SH" => "Saint Helena, Ascension and Tristan da Cunha",
              "KN" => "Saint Kitts and Nevis",
              "LC" => "Saint Lucia",
              "MF" => "Saint Martin (French part)",
              "PM" => "Saint Pierre and Miquelon",
              "VC" => "Saint Vincent and the Grenadines",
              "WS" => "Samoa",
              "SM" => "San Marino",
              "ST" => "Sao Tome and Principe",
              "SA" => "Saudi Arabia",
              "SN" => "Senegal",
              "RS" => "Serbia",
              "SC" => "Seychelles",
              "SL" => "Sierra Leone",
              "SG" => "Singapore",
              "SX" => "Sint Maarten (Dutch part)",
              "SK" => "Slovakia",
              "SI" => "Slovenia",
              "SB" => "Solomon Islands",
              "SO" => "Somalia",
              "ZA" => "South Africa",
              "GS" => "South Georgia and the South Sandwich Islands",
              "SS" => "South Sudan",
              "ES" => "Spain",
              "LK" => "Sri Lanka",
              "SD" => "Sudan",
              "SR" => "Suriname",
              "SJ" => "Svalbard and Jan Mayen",
              "SZ" => "Swaziland",
              "SE" => "Sweden",
              "CH" => "Switzerland",
              "SY" => "Syrian Arab Republic",
              "TW" => "Taiwan, Province of China",
              "TJ" => "Tajikistan",
              "TZ" => "Tanzania, United Republic of",
              "TH" => "Thailand",
              "TL" => "Timor-Leste",
              "TG" => "Togo",
              "TK" => "Tokelau",
              "TO" => "Tonga",
              "TT" => "Trinidad and Tobago",
              "TN" => "Tunisia",
              "TR" => "Turkey",
              "TM" => "Turkmenistan",
              "TC" => "Turks and Caicos Islands",
              "TV" => "Tuvalu",
              "UG" => "Uganda",
              "UA" => "Ukraine",
              "AE" => "United Arab Emirates",
              "GB" => "United Kingdom",
              "US" => "United States",
              "UM" => "United States Minor Outlying Islands",
              "UY" => "Uruguay",
              "UZ" => "Uzbekistan",
              "VU" => "Vanuatu",
              "VE" => "Venezuela, Bolivarian Republic of",
              "VN" => "Viet Nam",
              "VG" => "Virgin Islands, British",
              "VI" => "Virgin Islands, U.S.",
              "WF" => "Wallis and Futuna",
              "EH" => "Western Sahara",
              "YE" => "Yemen",
              "ZM" => "Zambia",
              "ZW" => "Zimbabwe"
        );

        if($key != ""){
              if(isset($countries[$key])){
                  return $countries[$key];
              }else{
                  return __("Unknown");
              }
        }

        return $countries;
    }
}